/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import java.util.Objects;

@Fluent(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
@Beta(value=Beta.SinceVersion.V1_28_0)
public class FunctionRuntimeStack {
    public static final FunctionRuntimeStack JAVA_8 = new FunctionRuntimeStack("java", "~2", "java|8", "DOCKER|mcr.microsoft.com/azure-functions/java:2.0-java8-appservice");
    private final String runtime;
    private final String version;
    private final String linuxFxVersionForConsumptionPlan;
    private final String linuxFxVersionForDedicatedPlan;

    public FunctionRuntimeStack(String runtime, String version, String linuxFxVersionForConsumptionPlan, String linuxFxVersionForDedicatedPlan) {
        this.runtime = runtime;
        this.version = version;
        this.linuxFxVersionForConsumptionPlan = linuxFxVersionForConsumptionPlan;
        this.linuxFxVersionForDedicatedPlan = linuxFxVersionForDedicatedPlan;
    }

    public String runtime() {
        return this.runtime;
    }

    public String version() {
        return this.version;
    }

    public String getLinuxFxVersionForConsumptionPlan() {
        return this.linuxFxVersionForConsumptionPlan;
    }

    public String getLinuxFxVersionForDedicatedPlan() {
        return this.linuxFxVersionForDedicatedPlan;
    }

    public String toString() {
        return this.runtime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionRuntimeStack that = (FunctionRuntimeStack)o;
        return this.runtime.equals(that.runtime) && this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.runtime, this.version);
    }
}

