/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenUtils {
    public static Xpp3Dom getPluginConfiguration(MavenProject mavenProject, String pluginKey) {
        Plugin plugin = MavenUtils.getPluginFromMavenModel(mavenProject.getModel(), pluginKey);
        return plugin == null ? null : (Xpp3Dom)plugin.getConfiguration();
    }

    public static String getJavaVersion(MavenProject mavenProject) {
        return Stream.of("java.version", "maven.compiler.source", "maven.compiler.release").map(key -> mavenProject.getProperties().getProperty((String)key)).filter(StringUtils::isNotEmpty).findFirst().map(Utils::getJavaMajorVersion).map(String::valueOf).orElse("");
    }

    public static Boolean isSpringBootProject(MavenProject mavenProject) {
        return MavenUtils.getPluginConfiguration(mavenProject, "org.springframework.boot:spring-boot-maven-plugin") != null;
    }

    private static Plugin getPluginFromMavenModel(Model model, String pluginKey) {
        if (model.getBuild() == null) {
            return null;
        }
        for (Plugin plugin : model.getBuild().getPlugins()) {
            if (!pluginKey.equalsIgnoreCase(plugin.getKey())) continue;
            return plugin;
        }
        if (model.getBuild().getPluginManagement() == null) {
            return null;
        }
        for (Plugin plugin : model.getBuild().getPluginManagement().getPlugins()) {
            if (!pluginKey.equalsIgnoreCase(plugin.getKey())) continue;
            return plugin;
        }
        return null;
    }

    private MavenUtils() {
    }
}

