/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.prompt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JsonLoader;
import com.microsoft.azure.maven.prompt.DefaultPrompter;
import com.microsoft.azure.maven.prompt.IPrompter;
import com.microsoft.azure.maven.prompt.InputValidateResult;
import com.microsoft.azure.maven.prompt.SchemaValidator;
import com.microsoft.azure.maven.utils.TemplateUtils;
import com.microsoft.azure.toolkit.lib.common.exception.InvalidConfigurationException;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class ConfigurationPrompter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationPrompter.class);
    private final ExpressionEvaluator expressionEvaluator;
    private final String pluginName;
    private IPrompter prompt;
    private Map<String, Map<String, Object>> templates;
    private Map<String, Object> commonVariables;
    private SchemaValidator validator;

    public ConfigurationPrompter(ExpressionEvaluator expressionEvaluator, String pluginName) {
        this.expressionEvaluator = expressionEvaluator;
        this.pluginName = pluginName;
    }

    public void initialize() throws IOException, InvalidConfigurationException {
        this.prompt = new DefaultPrompter();
        this.validator = new SchemaValidator();
        this.templates = new HashMap<String, Map<String, Object>>();
        this.commonVariables = new HashMap<String, Object>();
        Yaml yaml = new Yaml();
        HashSet<String> resourceNames = new HashSet<String>();
        try (InputStream inputStream = this.getClass().getResourceAsStream(String.format("/MessageTemplates-%s.yaml", this.pluginName));){
            Iterable rules = yaml.loadAll(inputStream);
            for (Object rule : rules) {
                Map map = (Map)rule;
                this.templates.put((String)map.get("id"), map);
                if (!map.containsKey("resource")) continue;
                resourceNames.add((String)map.get("resource"));
            }
        }
        for (String resourceName : resourceNames) {
            ObjectNode resourceSchema = (ObjectNode)JsonLoader.fromResource((String)String.format("/schema/com/microsoft/azure/toolkit/maven/%s/%s.json", this.pluginName, resourceName));
            if (!resourceSchema.has("properties")) {
                throw new InvalidConfigurationException(String.format("Bad schema for %s: missing properties field.", resourceName));
            }
            ObjectNode propertiesNode = (ObjectNode)resourceSchema.get("properties");
            IteratorUtils.forEach((Iterator)propertiesNode.fields(), prop -> this.validator.collectSingleProperty(resourceName, (String)prop.getKey(), (JsonNode)prop.getValue()));
        }
    }

    public void putCommonVariable(String key, Object obj) {
        this.commonVariables.put(key, obj);
    }

    public <T> T handleSelectOne(String templateId, List<T> options, T defaultEntity, Function<T, String> getNameFunc) throws IOException, InvalidConfigurationException {
        Map<String, Object> variables = this.createVariableTables(templateId);
        boolean isRequired = TemplateUtils.evalBoolean("required", variables);
        if (options.size() == 0) {
            if (isRequired) {
                throw new InvalidConfigurationException(TemplateUtils.evalText("message.empty_options", variables));
            }
            String warningMessage = TemplateUtils.evalExpressionValue("message.empty_options", variables);
            if (StringUtils.isNotBlank((CharSequence)warningMessage)) {
                log.warn(warningMessage);
            }
            return null;
        }
        boolean autoSelect = TemplateUtils.evalBoolean("auto_select", variables);
        if (options.size() == 1) {
            if (autoSelect) {
                log.info(TemplateUtils.evalText("message.auto_select", variables));
                return options.get(0);
            }
            if (!this.prompt.promoteYesNo(TemplateUtils.evalText("promote.one", variables), isRequired, isRequired).booleanValue()) {
                if (isRequired) {
                    throw new InvalidConfigurationException(TemplateUtils.evalText("message.select_none", variables));
                }
                return null;
            }
            return options.get(0);
        }
        if (defaultEntity == null && variables.containsKey("default_index")) {
            defaultEntity = options.get((Integer)variables.get("default_index"));
        }
        return this.prompt.promoteSingleEntity(TemplateUtils.evalText("promote.header", variables), TemplateUtils.evalText("promote.many", variables), options, defaultEntity, getNameFunc, isRequired);
    }

    public <T> List<T> handleMultipleCase(String templateId, List<T> options, Function<T, String> getNameFunc) throws IOException, InvalidConfigurationException {
        String warningMessage;
        Map<String, Object> variables = this.createVariableTables(templateId);
        boolean allowEmpty = TemplateUtils.evalBoolean("allow_empty", variables);
        if (options.size() == 0) {
            if (!allowEmpty) {
                throw new InvalidConfigurationException(TemplateUtils.evalText("message.empty_options", variables));
            }
            String warningMessage2 = TemplateUtils.evalExpressionValue("message.empty_options", variables);
            if (StringUtils.isNotBlank((CharSequence)warningMessage2)) {
                log.warn(warningMessage2);
            }
            return options;
        }
        boolean autoSelect = TemplateUtils.evalBoolean("auto_select", variables);
        boolean defaultSelected = TemplateUtils.evalBoolean("default_selected", variables);
        if (options.size() == 1) {
            if (autoSelect) {
                log.info(TemplateUtils.evalText("message.auto_select", variables));
                return options;
            }
            if (!this.prompt.promoteYesNo(TemplateUtils.evalText("promote.one", variables), defaultSelected, false).booleanValue()) {
                return Collections.emptyList();
            }
            return options;
        }
        List<T> selectedEntities = this.prompt.promoteMultipleEntities(TemplateUtils.evalText("promote.header", variables), TemplateUtils.evalText("promote.many", variables), TemplateUtils.evalText("promote.header", variables), options, getNameFunc, allowEmpty, defaultSelected ? "to select ALL" : "to select NONE", defaultSelected ? options : Collections.emptyList());
        if (selectedEntities.isEmpty() && StringUtils.isNotBlank((CharSequence)(warningMessage = TemplateUtils.evalExpressionValue("message.select_none", variables)))) {
            log.warn(warningMessage);
        }
        return selectedEntities;
    }

    public String handle(String templateId, boolean autoApplyDefault) throws InvalidConfigurationException, IOException {
        return this.handle(templateId, autoApplyDefault, null);
    }

    public String handle(String templateId, boolean autoApplyDefault, Object cliParameter) throws InvalidConfigurationException, IOException {
        String errorMessage;
        Map<String, Object> variables = this.createVariableTables(templateId);
        String resourceName = (String)variables.get("resource");
        String propertyName = (String)variables.get("property");
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            throw new InvalidConfigurationException("Cannot find property in template: " + templateId);
        }
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            throw new InvalidConfigurationException("Cannot find resource in template: " + templateId);
        }
        Map<String, Object> schema = this.validator.getSchemaMap(resourceName, propertyName);
        variables.put("schema", schema);
        Object defaultObj = variables.get("default_val");
        if (defaultObj instanceof String) {
            defaultObj = TemplateUtils.evalPlainText("default_val", variables);
        } else if (defaultObj == null) {
            defaultObj = schema.get("default");
        }
        String defaultObjectStr = Objects.toString(defaultObj, null);
        String type = (String)schema.get("type");
        if (cliParameter != null) {
            errorMessage = this.validator.validateSingleProperty(resourceName, propertyName, cliParameter.toString());
            if (errorMessage == null) {
                return cliParameter.toString();
            }
            System.out.println(TextUtils.yellow((String)String.format("Validation failure for %s[%s]: %s", propertyName, cliParameter, errorMessage)));
        }
        if (autoApplyDefault) {
            if (defaultObj != null) {
                errorMessage = this.validator.validateSingleProperty(resourceName, propertyName, defaultObjectStr);
                if (errorMessage == null) {
                    return defaultObjectStr;
                }
                throw new InvalidConfigurationException(String.format("Default value '%s' cannot be applied to %s due to error: %s", defaultObjectStr, propertyName, errorMessage));
            }
            return null;
        }
        String promoteMessage = TemplateUtils.evalText("promote", variables);
        return this.prompt.promoteString(promoteMessage, Objects.toString(defaultObj, null), input -> {
            String value;
            if ("boolean".equals(type)) {
                if (input.equalsIgnoreCase("Y")) {
                    input = "true";
                }
                if (input.equalsIgnoreCase("N")) {
                    input = "false";
                }
            }
            try {
                value = this.evaluateMavenExpression((String)input);
                if (value == null) {
                    return InputValidateResult.error(String.format("Cannot evaluate maven expression: %s", input));
                }
            }
            catch (ExpressionEvaluationException e) {
                return InputValidateResult.error(e.getMessage());
            }
            String errorMessage = this.validator.validateSingleProperty(resourceName, propertyName, value);
            return errorMessage == null ? InputValidateResult.wrap(input) : InputValidateResult.error(errorMessage);
        }, TemplateUtils.evalBoolean("required", variables));
    }

    public boolean handleConfirm(String message, Boolean defaultVal, Boolean required) throws IOException {
        return this.prompt.promoteYesNo(message, defaultVal, required);
    }

    public void confirmChanges(Map<String, String> changesToConfirm, Supplier<Integer> confirmedAction) throws IOException {
        Map<String, Object> variables = this.createVariableTables("confirm");
        System.out.println(TemplateUtils.evalText("promote.header", variables));
        for (Map.Entry<String, String> entry : changesToConfirm.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
            ConfigurationPrompter.printConfirmation(entry.getKey(), entry.getValue());
        }
        Boolean userConfirm = this.prompt.promoteYesNo(TemplateUtils.evalText("promote.footer", variables), TemplateUtils.evalBoolean("default_val", variables), TemplateUtils.evalBoolean("required", variables));
        if (userConfirm == null || !userConfirm.booleanValue()) {
            log.info(TemplateUtils.evalText("message.skip", variables));
            return;
        }
        Integer appliedCount = confirmedAction.get();
        if (appliedCount == null || appliedCount == 0) {
            log.info(TemplateUtils.evalText("message.none", variables));
        } else if (appliedCount == 1) {
            log.info(TemplateUtils.evalText("message.one", variables));
        } else {
            log.info(TemplateUtils.evalText("message.many", variables));
        }
    }

    public void close() throws IOException {
        this.prompt.close();
    }

    private Map<String, Object> createVariableTables(String templateId) {
        Map<String, Object> variables = this.templates.get(templateId);
        if (variables == null) {
            throw new IllegalArgumentException("Cannot find template: " + templateId);
        }
        variables.putAll(this.commonVariables);
        return variables;
    }

    private String evaluateMavenExpression(String input) throws ExpressionEvaluationException {
        if (input != null && input.contains("${")) {
            return (String)this.expressionEvaluator.evaluate(input);
        }
        return input;
    }

    private static void printConfirmation(String key, Object value) {
        System.out.printf("%-17s : %s%n", key, TextUtils.cyan((String)Objects.toString(value)));
    }
}

