/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.azure.core.util.Configuration;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import com.microsoft.azure.toolkit.lib.common.proxy.ProxyManager;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.settings.Proxy;

public class ProxyUtils {
    public static void initProxy(MavenExecutionRequest request) {
        Proxy mavenProxy;
        List mavenProxies;
        ProxyManager proxyManager = ProxyManager.getInstance();
        proxyManager.init();
        String source = "system";
        if (!proxyManager.forceUseSystemProxy() && request != null && CollectionUtils.isNotEmpty((Collection)(mavenProxies = request.getProxies())) && (mavenProxy = (Proxy)mavenProxies.stream().filter(proxy -> proxy.isActive() && proxy.getPort() > 0 && StringUtils.isNotBlank((CharSequence)proxy.getHost())).findFirst().orElse(null)) != null) {
            proxyManager.configure(mavenProxy.getHost(), Integer.valueOf(mavenProxy.getPort()));
            source = "maven";
        }
        if (source != null && Objects.nonNull(proxyManager.getProxy())) {
            Log.info((String)String.format("Use %s proxy: %s:%s", source, TextUtils.cyan((String)proxyManager.getHttpProxyHost()), TextUtils.cyan((String)Integer.toString(proxyManager.getHttpProxyPort()))));
            Azure.az().config().setHttpProxy((InetSocketAddress)proxyManager.getProxy().address());
            Configuration.getGlobalConfiguration().put("HTTP_PROXY", String.format("http://%s:%s", proxyManager.getHttpProxyHost(), proxyManager.getHttpProxyPort()));
        }
    }
}

