/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.model;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;

public class DeploymentResource
extends Resource {
    private static final Path FTP_ROOT = Paths.get("/site/wwwroot", new String[0]);
    private String type;

    public boolean isExternalResource() {
        if (this.isOneDeployResource()) {
            return false;
        }
        Path target = Paths.get(this.getAbsoluteTargetPath(), new String[0]);
        return !target.startsWith(FTP_ROOT);
    }

    public String getAbsoluteTargetPath() {
        String targetPath = StringUtils.defaultString((String)this.getTargetPath());
        return StringUtils.startsWith((CharSequence)targetPath, (CharSequence)"/") ? targetPath : FTP_ROOT.resolve(Paths.get(targetPath, new String[0])).normalize().toString();
    }

    public boolean isOneDeployResource() {
        return StringUtils.isNotBlank((CharSequence)this.getType());
    }

    public String toString() {
        return "DeploymentResource{type=" + this.type + ", " + super.toString() + '}';
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

