// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator

package com.microsoft.azure.keyvault.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.keyvault.cryptography.ByteExtensions;

/**
 * A certificate operation is returned in case of asynchronous requests.
 */
public class CertificateOperation extends com.microsoft.azure.keyvault.models.custom.CertificateOperation {
    /**
     * The certificate id.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /**
     * Parameters for the issuer of the X509 component of a certificate.
     */
    @JsonProperty(value = "issuer")
    private IssuerParameters issuerParameters;

    /**
     * The certificate signing request (CSR) that is being used in the
     * certificate operation.
     */
    @JsonProperty(value = "csr")
    private byte[] csr;

    /**
     * Indicates if cancellation was requested on the certificate operation.
     */
    @JsonProperty(value = "cancellation_requested")
    private Boolean cancellationRequested;

    /**
     * Status of the certificate operation.
     */
    @JsonProperty(value = "status")
    private String status;

    /**
     * The status details of the certificate operation.
     */
    @JsonProperty(value = "status_details")
    private String statusDetails;

    /**
     * Error encountered, if any, during the certificate operation.
     */
    @JsonProperty(value = "error")
    private Error error;

    /**
     * Location which contains the result of the certificate operation.
     */
    @JsonProperty(value = "target")
    private String target;

    /**
     * Identifier for the certificate operation.
     */
    @JsonProperty(value = "request_id")
    private String requestId;

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the issuerParameters value.
     *
     * @return the issuerParameters value
     */
    public IssuerParameters issuerParameters() {
        return this.issuerParameters;
    }

    /**
     * Set the issuerParameters value.
     *
     * @param issuerParameters the issuerParameters value to set
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation withIssuerParameters(IssuerParameters issuerParameters) {
        this.issuerParameters = issuerParameters;
        return this;
    }

    /**
     * Get the csr value.
     *
     * @return the csr value
     */
    public byte[] csr() {
        return ByteExtensions.clone(this.csr);
    }

    /**
     * Set the csr value.
     *
     * @param csr the csr value to set
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation withCsr(byte[] csr) {
        this.csr = ByteExtensions.clone(csr);
        return this;
    }

    /**
     * Get the cancellationRequested value.
     *
     * @return the cancellationRequested value
     */
    public Boolean cancellationRequested() {
        return this.cancellationRequested;
    }

    /**
     * Set the cancellationRequested value.
     *
     * @param cancellationRequested the cancellationRequested value to set
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation withCancellationRequested(Boolean cancellationRequested) {
        this.cancellationRequested = cancellationRequested;
        return this;
    }

    /**
     * Get the status value.
     *
     * @return the status value
     */
    public String status() {
        return this.status;
    }

    /**
     * Set the status value.
     *
     * @param status the status value to set
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the statusDetails value.
     *
     * @return the statusDetails value
     */
    public String statusDetails() {
        return this.statusDetails;
    }

    /**
     * Set the statusDetails value.
     *
     * @param statusDetails the statusDetails value to set
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation withStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
        return this;
    }

    /**
     * Get the error value.
     *
     * @return the error value
     */
    public Error error() {
        return this.error;
    }

    /**
     * Set the error value.
     *
     * @param error the error value to set
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation withError(Error error) {
        this.error = error;
        return this;
    }

    /**
     * Get the target value.
     *
     * @return the target value
     */
    public String target() {
        return this.target;
    }

    /**
     * Set the target value.
     *
     * @param target the target value to set
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation withTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the requestId value.
     *
     * @return the requestId value
     */
    public String requestId() {
        return this.requestId;
    }

    /**
     * Set the requestId value.
     *
     * @param requestId the requestId value to set
     * @return the CertificateOperation object itself.
     */
    public CertificateOperation withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }
}
