/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.query.DefaultDocumentQueryExecutionContext;
import com.microsoft.azure.cosmosdb.rx.internal.query.DocumentQueryExecutionContextFactory;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionContext;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Single;
import rx.functions.Func1;

public class ProxyDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionContext<T> {
    private IDocumentQueryExecutionContext<T> innerExecutionContext;
    private IDocumentQueryClient client;
    private ResourceType resourceTypeEnum;
    private Class<T> resourceType;
    private FeedOptions feedOptions;
    private SqlQuerySpec query;
    private String resourceLink;
    private DocumentCollection collection;
    private UUID correlatedActivityId;
    private boolean isContinuationExpected;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ProxyDocumentQueryExecutionContext(IDocumentQueryExecutionContext<T> innerExecutionContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, DocumentCollection collection, boolean isContinuationExpected, UUID correlatedActivityId) {
        this.innerExecutionContext = innerExecutionContext;
        this.client = client;
        this.resourceTypeEnum = resourceTypeEnum;
        this.resourceType = resourceType;
        this.query = query;
        this.feedOptions = feedOptions;
        this.resourceLink = resourceLink;
        this.collection = collection;
        this.isContinuationExpected = isContinuationExpected;
        this.correlatedActivityId = correlatedActivityId;
    }

    @Override
    public Observable<FeedResponse<T>> executeAsync() {
        Func1 func = t -> {
            logger.debug("Received non result message from gateway", t);
            if (!(t instanceof Exception)) {
                logger.error("Unexpected failure", t);
                return Observable.error((Throwable)t);
            }
            if (!this.isCrossPartitionQuery((Exception)t)) {
                logger.debug("Failure from gateway", t);
                return Observable.error((Throwable)t);
            }
            logger.debug("Setting up query pipeline using the query plan received form gateway");
            DocumentClientException dce = (DocumentClientException)((Object)t);
            PartitionedQueryExecutionInfo partitionedQueryExecutionInfo = new PartitionedQueryExecutionInfo(dce.getError().getPartitionedQueryExecutionInfo());
            logger.debug("Query Plan from gateway {}", (Object)partitionedQueryExecutionInfo);
            DefaultDocumentQueryExecutionContext queryExecutionContext = (DefaultDocumentQueryExecutionContext)this.innerExecutionContext;
            Single<List<PartitionKeyRange>> partitionKeyRanges = queryExecutionContext.getTargetPartitionKeyRanges(this.collection.getResourceId(), partitionedQueryExecutionInfo.getQueryRanges());
            Observable exContext = partitionKeyRanges.toObservable().flatMap(pkranges -> DocumentQueryExecutionContextFactory.createSpecializedDocumentQueryExecutionContextAsync(this.client, this.resourceTypeEnum, this.resourceType, this.query, this.feedOptions, this.resourceLink, this.isContinuationExpected, partitionedQueryExecutionInfo, pkranges, this.collection.getResourceId(), this.correlatedActivityId));
            return exContext.flatMap(context -> context.executeAsync());
        };
        return this.innerExecutionContext.executeAsync().onErrorResumeNext(func);
    }

    private boolean isCrossPartitionQuery(Exception exception) {
        DocumentClientException clientException = (DocumentClientException)((Object)Utils.as((Object)exception, DocumentClientException.class));
        if (clientException == null) {
            return false;
        }
        return Exceptions.isStatusCode(clientException, 400) && Exceptions.isSubStatusCode(clientException, 1004);
    }

    public static <T extends Resource> Observable<ProxyDocumentQueryExecutionContext<T>> createAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, DocumentCollection collection, boolean isContinuationExpected, UUID correlatedActivityId) {
        DefaultDocumentQueryExecutionContext<T> innerExecutionContext = new DefaultDocumentQueryExecutionContext<T>(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, correlatedActivityId, isContinuationExpected);
        return Observable.just(new ProxyDocumentQueryExecutionContext<T>(innerExecutionContext, client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, collection, isContinuationExpected, correlatedActivityId));
    }
}

