/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.RequestChargeTracker;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.cosmosdb.internal.routing.Range;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.query.DocumentProducer;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionComponent;
import com.microsoft.azure.cosmosdb.rx.internal.query.ParallelDocumentQueryExecutionContextBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func3;

public class ParallelDocumentQueryExecutionContext<T extends Resource>
extends ParallelDocumentQueryExecutionContextBase<T> {
    private ParallelDocumentQueryExecutionContext(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, String rewrittenQuery, String collectionRid, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        super(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, rewrittenQuery, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
    }

    public static <T extends Resource> Observable<IDocumentQueryExecutionComponent<T>> createAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, String collectionRid, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, List<PartitionKeyRange> targetRanges, int initialPageSize, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        ParallelDocumentQueryExecutionContext<T> context = new ParallelDocumentQueryExecutionContext<T>(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, partitionedQueryExecutionInfo.getQueryInfo().getRewrittenQuery(), collectionRid, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        super.initialize(collectionRid, partitionedQueryExecutionInfo.getQueryRanges(), targetRanges, initialPageSize);
        return Observable.just(context);
    }

    private void initialize(String collectionRid, List<Range<String>> queryRanges, List<PartitionKeyRange> targetRanges, int initialPageSize) {
        super.initialize(collectionRid, queryRanges, targetRanges, initialPageSize, this.querySpec);
    }

    @Override
    public Observable<FeedResponse<T>> drainAsync(int maxPageSize) {
        List obs = this.documentProducers.stream().map(dp -> dp.produceAsync().map(dpp -> dpp.pageResult)).collect(Collectors.toList());
        return Observable.concat(obs).compose(new EmptyPagesFilterTransformer(new RequestChargeTracker(), maxPageSize));
    }

    @Override
    public Observable<FeedResponse<T>> executeAsync() {
        return this.drainAsync(this.feedOptions.getMaxItemCount());
    }

    @Override
    protected DocumentProducer<T> createDocumentProducer(String collectionRid, PartitionKeyRange targetRange, int initialPageSize, SqlQuerySpec querySpecForInit, Map<String, String> commonRequestHeaders, Func3<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc, Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeFunc, Func0<IDocumentClientRetryPolicy> createRetryPolicyFunc) {
        return new DocumentProducer<T>(this.client, collectionRid, createRequestFunc, executeFunc, targetRange, collectionRid, (Func0<IDocumentClientRetryPolicy>)((Func0)() -> this.client.getRetryPolicyFactory().getRequestPolicy()), this.resourceType, this.correlatedActivityId, initialPageSize, null, this.top);
    }

    private static class EmptyPagesFilterTransformer<T extends Resource>
    implements Observable.Transformer<FeedResponse<T>, FeedResponse<T>> {
        private final RequestChargeTracker tracker;

        public EmptyPagesFilterTransformer(RequestChargeTracker tracker, int maxPageSize) {
            this.tracker = tracker;
        }

        private FeedResponse<T> plusCharge(FeedResponse<T> page, double charge) {
            HashMap<String, String> headers = new HashMap<String, String>(page.getResponseHeaders());
            double pageCharge = page.getRequestCharge();
            headers.put("x-ms-request-charge", String.valueOf(pageCharge += charge));
            return BridgeInternal.createFeedResponse(page.getResults(), headers);
        }

        private static Map<String, String> headerResponse(double requestCharge) {
            return Utils.immutableMapOf((Object)"x-ms-request-charge", (Object)String.valueOf(requestCharge));
        }

        public Observable<FeedResponse<T>> call(Observable<FeedResponse<T>> source) {
            return source.filter(p -> {
                if (p.getResults().isEmpty()) {
                    this.tracker.addCharge(p.getRequestCharge());
                    return false;
                }
                return true;
            }).map(p -> {
                double charge = this.tracker.getAndResetCharge();
                if (charge > 0.0) {
                    return this.plusCharge((FeedResponse<T>)p, charge);
                }
                return p;
            }).switchIfEmpty(Observable.defer(() -> Observable.just(BridgeInternal.createFeedResponse(Utils.immutableListOf(), EmptyPagesFilterTransformer.headerResponse(this.tracker.getAndResetCharge())))));
        }
    }
}

