/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.github.davidmoten.rx.Transformers;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.internal.RequestChargeTracker;
import com.microsoft.azure.cosmosdb.internal.query.orderbyquery.OrderByRowResult;
import com.microsoft.azure.cosmosdb.internal.query.orderbyquery.OrderbyRowComparer;
import com.microsoft.azure.cosmosdb.rx.internal.query.DocumentProducer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import rx.Observable;

class OrderByUtils {
    OrderByUtils() {
    }

    public static <T extends Resource> Observable<OrderByRowResult<T>> orderedMerge(Class<T> klass, OrderbyRowComparer<T> consumeComparer, RequestChargeTracker tracker, List<DocumentProducer<T>> documentProducers) {
        return OrderByUtils.toOrderByQueryResultObservable(klass, documentProducers.get(0), tracker).compose(Transformers.orderedMergeWith((Collection)documentProducers.subList(1, documentProducers.size()).stream().map(producer -> OrderByUtils.toOrderByQueryResultObservable(klass, producer, tracker)).collect(Collectors.toList()), consumeComparer, (boolean)false, (int)1));
    }

    private static <T extends Resource> Observable<OrderByRowResult<T>> toOrderByQueryResultObservable(Class<T> klass, DocumentProducer<T> producer, RequestChargeTracker tracker) {
        return producer.produceAsync().compose(new PageToItemTransformer<T>(klass, tracker));
    }

    private static class PageToItemTransformer<T extends Resource>
    implements Observable.Transformer<DocumentProducer.DocumentProducerFeedResponse, OrderByRowResult<T>> {
        private final RequestChargeTracker tracker;
        private final Class<T> klass;

        public PageToItemTransformer(Class<T> klass, RequestChargeTracker tracker) {
            this.klass = klass;
            this.tracker = tracker;
        }

        public Observable<OrderByRowResult<T>> call(Observable<DocumentProducer.DocumentProducerFeedResponse> source) {
            return source.flatMap(documentProducerFeedResponse -> {
                this.tracker.addCharge(documentProducerFeedResponse.pageResult.getRequestCharge());
                Observable x = Observable.from((Iterable)documentProducerFeedResponse.pageResult.getResults());
                return x.map(r -> new OrderByRowResult<T>(this.klass, r.toJson(), documentProducerFeedResponse.sourcePartitionKeyRange));
            }, 1);
        }
    }
}

