/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.Document;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.Undefined;
import com.microsoft.azure.cosmosdb.internal.query.QueryItem;
import com.microsoft.azure.cosmosdb.internal.query.aggregation.AggregateOperator;
import com.microsoft.azure.cosmosdb.internal.query.aggregation.Aggregator;
import com.microsoft.azure.cosmosdb.internal.query.aggregation.AverageAggregator;
import com.microsoft.azure.cosmosdb.internal.query.aggregation.CountAggregator;
import com.microsoft.azure.cosmosdb.internal.query.aggregation.MaxAggregator;
import com.microsoft.azure.cosmosdb.internal.query.aggregation.MinAggregator;
import com.microsoft.azure.cosmosdb.internal.query.aggregation.SumAggregator;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import rx.Observable;

public class AggregateDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionComponent<T> {
    private IDocumentQueryExecutionComponent<T> component;
    private Aggregator aggregator;

    public AggregateDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, Collection<AggregateOperator> aggregateOperators) {
        this.component = component;
        AggregateOperator aggregateOperator = aggregateOperators.iterator().next();
        switch (aggregateOperator) {
            case Average: {
                this.aggregator = new AverageAggregator();
                break;
            }
            case Count: {
                this.aggregator = new CountAggregator();
                break;
            }
            case Max: {
                this.aggregator = new MaxAggregator();
                break;
            }
            case Min: {
                this.aggregator = new MinAggregator();
                break;
            }
            case Sum: {
                this.aggregator = new SumAggregator();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + aggregateOperator.toString());
            }
        }
    }

    @Override
    public Observable<FeedResponse<T>> drainAsync(int maxPageSize) {
        return this.component.drainAsync(maxPageSize).toList().map(superList -> {
            double requestCharge = 0.0;
            ArrayList<Document> aggregateResults = new ArrayList<Document>();
            HashMap<String, String> headers = new HashMap<String, String>();
            for (FeedResponse page : superList) {
                if (page.getResults().size() == 0) {
                    headers.put("x-ms-request-charge", Double.toString(requestCharge));
                    FeedResponse frp = BridgeInternal.createFeedResponse(aggregateResults, headers);
                    return frp;
                }
                Document doc = (Document)page.getResults().get(0);
                requestCharge += page.getRequestCharge();
                QueryItem values = new QueryItem(doc.toJson());
                this.aggregator.aggregate(values.getItem());
            }
            if (this.aggregator.getResult() == null || !this.aggregator.getResult().equals(Undefined.Value())) {
                Document aggregateDocument = new Document();
                aggregateDocument.set("_aggregate", this.aggregator.getResult());
                aggregateResults.add(aggregateDocument);
            }
            headers.put("x-ms-request-charge", Double.toString(requestCharge));
            FeedResponse frp = BridgeInternal.createFeedResponse(aggregateResults, headers);
            return frp;
        });
    }

    public static <T extends Resource> Observable<IDocumentQueryExecutionComponent<T>> createAsync(Observable<IDocumentQueryExecutionComponent<T>> observableComponent, Collection<AggregateOperator> aggregates) {
        return observableComponent.map(component -> new AggregateDocumentQueryExecutionContext(component, aggregates));
    }

    public IDocumentQueryExecutionComponent<T> getComponent() {
        return this.component;
    }
}

