/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.caches;

import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceId;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyRangeIdentity;
import com.microsoft.azure.cosmosdb.rx.internal.InvalidPartitionException;
import com.microsoft.azure.cosmosdb.rx.internal.NotFoundException;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.caches.AsyncCache;
import com.microsoft.azure.cosmosdb.rx.internal.caches.IEqualityComparer;
import org.apache.commons.lang3.StringUtils;
import rx.Completable;
import rx.Single;
import rx.functions.Func0;

public abstract class RxCollectionCache {
    private final AsyncCache<String, DocumentCollection> collectionInfoByNameCache = new AsyncCache(new CollectionRidComparer());
    private final AsyncCache<String, DocumentCollection> collectionInfoByIdCache = new AsyncCache(new CollectionRidComparer());

    protected RxCollectionCache() {
    }

    public Single<DocumentCollection> resolveCollectionAsync(RxDocumentServiceRequest request) {
        Completable init = null;
        if (request.getIsNameBased()) {
            if (request.isForceNameCacheRefresh()) {
                Completable completable = this.refreshAsync(request);
                init = completable.andThen(Completable.fromAction(() -> request.setForceNameCacheRefresh(false)));
            }
            Single collectionInfoObs = this.ResolveByPartitionKeyRangeIdentityAsync(request.getPartitionKeyRangeIdentity());
            if (init != null) {
                collectionInfoObs = init.andThen(collectionInfoObs);
            }
            return collectionInfoObs.flatMap(collectionInfo -> {
                if (collectionInfo != null) {
                    return Single.just((Object)collectionInfo);
                }
                if (request.requestContext.resolvedCollectionRid == null) {
                    Single<DocumentCollection> collectionInfoRes = this.resolveByNameAsync(request.getResourceAddress());
                    return collectionInfoRes.flatMap(collection -> {
                        request.setResourceId(collection.getResourceId());
                        request.requestContext.resolvedCollectionRid = collection.getResourceId();
                        return Single.just((Object)collection);
                    });
                }
                return this.resolveByRidAsync(request.requestContext.resolvedCollectionRid);
            });
        }
        return this.ResolveByPartitionKeyRangeIdentityAsync(request.getPartitionKeyRangeIdentity()).flatMap(collection -> {
            if (collection != null) {
                return Single.just((Object)collection);
            }
            return this.resolveByRidAsync(request.getResourceAddress());
        });
    }

    public void refresh(String resourceAddress) {
        if (PathsHelper.isNameBased((String)resourceAddress)) {
            String resourceFullName = PathsHelper.getCollectionPath((String)resourceAddress);
            this.collectionInfoByNameCache.refresh(resourceFullName, (Func0<Single<DocumentCollection>>)((Func0)() -> {
                Single<DocumentCollection> collectionObs = this.getByNameAsync(resourceFullName);
                return collectionObs.doOnSuccess(collection -> this.collectionInfoByIdCache.set(collection.getResourceId(), (DocumentCollection)collection));
            }));
        }
    }

    protected abstract Single<DocumentCollection> getByRidAsync(String var1);

    protected abstract Single<DocumentCollection> getByNameAsync(String var1);

    private Single<DocumentCollection> ResolveByPartitionKeyRangeIdentityAsync(PartitionKeyRangeIdentity partitionKeyRangeIdentity) {
        if (partitionKeyRangeIdentity != null && partitionKeyRangeIdentity.getCollectionRid() != null) {
            return this.resolveByRidAsync(partitionKeyRangeIdentity.getCollectionRid()).onErrorResumeNext(e -> {
                if (e instanceof NotFoundException) {
                    return Single.error((Throwable)((Object)new InvalidPartitionException("The specified document collection is invalid.")));
                }
                return Single.error((Throwable)e);
            });
        }
        return Single.just(null);
    }

    private Single<DocumentCollection> resolveByRidAsync(String resourceId) {
        ResourceId resourceIdParsed = ResourceId.parse((String)resourceId);
        String collectionResourceId = resourceIdParsed.getDocumentCollectionId().toString();
        return this.collectionInfoByIdCache.getAsync(collectionResourceId, null, (Func0<Single<DocumentCollection>>)((Func0)() -> this.getByRidAsync(collectionResourceId)));
    }

    private Single<DocumentCollection> resolveByNameAsync(String resourceAddress) {
        String resourceFullName = PathsHelper.getCollectionPath((String)resourceAddress);
        return this.collectionInfoByNameCache.getAsync(resourceFullName, null, (Func0<Single<DocumentCollection>>)((Func0)() -> {
            Single<DocumentCollection> collectionObs = this.getByNameAsync(resourceFullName);
            return collectionObs.doOnSuccess(collection -> this.collectionInfoByIdCache.set(collection.getResourceId(), (DocumentCollection)collection));
        }));
    }

    private Completable refreshAsync(RxDocumentServiceRequest request) {
        String resourceFullName = PathsHelper.getCollectionPath((String)request.getResourceAddress());
        Completable completable = null;
        if (request.requestContext.resolvedCollectionRid != null) {
            DocumentCollection obsoleteValue = new DocumentCollection();
            obsoleteValue.setResourceId(request.requestContext.resolvedCollectionRid);
            completable = this.collectionInfoByNameCache.getAsync(resourceFullName, obsoleteValue, (Func0<Single<DocumentCollection>>)((Func0)() -> {
                Single<DocumentCollection> collectionObs = this.getByNameAsync(resourceFullName);
                return collectionObs.doOnSuccess(collection -> this.collectionInfoByIdCache.set(collection.getResourceId(), (DocumentCollection)collection));
            })).toCompletable();
        } else {
            completable = Completable.fromAction(() -> this.refresh(request.getResourceAddress()));
        }
        return completable.doOnCompleted(() -> {
            request.requestContext.resolvedCollectionRid = null;
        });
    }

    private class CollectionRidComparer
    implements IEqualityComparer<DocumentCollection> {
        private CollectionRidComparer() {
        }

        @Override
        public boolean areEqual(DocumentCollection left, DocumentCollection right) {
            if (left == null && right == null) {
                return true;
            }
            if (left == null ^ right == null) {
                return false;
            }
            return StringUtils.equals((CharSequence)left.getResourceId(), (CharSequence)right.getResourceId());
        }
    }
}

