/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

public class RetryUtils {
    public static Func1<Observable<? extends Throwable>, Observable<Long>> toRetryWhenFunc(final IRetryPolicy policy) {
        return new Func1<Observable<? extends Throwable>, Observable<Long>>(){

            public Observable<Long> call(Observable<? extends Throwable> throwableObs) {
                return throwableObs.flatMap(t -> {
                    Exception e = (Exception)Utils.as((Object)t, Exception.class);
                    if (e == null) {
                        return Observable.error((Throwable)t);
                    }
                    return policy.shouldRetry(e).toObservable().flatMap(s -> {
                        if (s.backOffTime != null) {
                            return Observable.timer((long)s.backOffTime.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
                        }
                        if (s.exception != null) {
                            return Observable.error((Throwable)s.exception);
                        }
                        return Observable.error((Throwable)t);
                    });
                });
            }
        };
    }
}

