/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.routing.CollectionRoutingMap;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.caches.IPartitionKeyRangeCache;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxCollectionCache;
import java.time.Duration;
import rx.Observable;
import rx.Single;

public class PartitionKeyRangeGoneRetryPolicy
implements IDocumentClientRetryPolicy {
    private final RxCollectionCache collectionCache;
    private final IDocumentClientRetryPolicy nextRetryPolicy;
    private final IPartitionKeyRangeCache partitionKeyRangeCache;
    private final String collectionLink;
    private volatile boolean retried;

    public PartitionKeyRangeGoneRetryPolicy(RxCollectionCache collectionCache, IPartitionKeyRangeCache partitionKeyRangeCache, String collectionLink, IDocumentClientRetryPolicy nextRetryPolicy) {
        this.collectionCache = collectionCache;
        this.partitionKeyRangeCache = partitionKeyRangeCache;
        this.collectionLink = collectionLink;
        this.nextRetryPolicy = nextRetryPolicy;
    }

    @Override
    public Single<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception exception) {
        DocumentClientException clientException = (DocumentClientException)((Object)Utils.as((Object)exception, DocumentClientException.class));
        if (clientException != null && Exceptions.isStatusCode(clientException, 410) && Exceptions.isSubStatusCode(clientException, 1002)) {
            if (this.retried) {
                return Single.just((Object)IRetryPolicy.ShouldRetryResult.error((Exception)((Object)clientException)));
            }
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.DocumentCollection, (String)this.collectionLink, null);
            Single<DocumentCollection> collectionObs = this.collectionCache.resolveCollectionAsync(request);
            Single retryTimeObservable = collectionObs.flatMap(collection -> {
                Single<CollectionRoutingMap> routingMapObs = this.partitionKeyRangeCache.tryLookupAsync(collection.getResourceId(), null);
                Single refreshedRoutingMapObs = routingMapObs.flatMap(routingMap -> {
                    if (routingMap != null) {
                        return this.partitionKeyRangeCache.tryLookupAsync(collection.getResourceId(), (CollectionRoutingMap)routingMap);
                    }
                    return Observable.just((Object)null).toSingle();
                });
                return refreshedRoutingMapObs.flatMap(rm -> {
                    this.retried = true;
                    return Single.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(Duration.ZERO));
                });
            });
            return retryTimeObservable;
        }
        return this.nextRetryPolicy.shouldRetry(exception);
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.nextRetryPolicy.onBeforeSendRequest(request);
    }
}

