/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxClientCollectionCache;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Single;

public class PartitionKeyMismatchRetryPolicy
implements IDocumentClientRetryPolicy {
    private RxClientCollectionCache clientCollectionCache;
    private IDocumentClientRetryPolicy nextRetryPolicy;
    private AtomicInteger retriesAttempted = new AtomicInteger(0);
    private String collectionLink;
    private static final int MaxRetries = 1;

    public PartitionKeyMismatchRetryPolicy(RxClientCollectionCache clientCollectionCache, IDocumentClientRetryPolicy nextRetryPolicy, String resourceFullName) {
        this.clientCollectionCache = clientCollectionCache;
        this.nextRetryPolicy = nextRetryPolicy;
        this.collectionLink = com.microsoft.azure.cosmosdb.internal.Utils.getCollectionName((String)resourceFullName);
    }

    @Override
    public Single<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception exception) {
        DocumentClientException clientException = (DocumentClientException)((Object)Utils.as((Object)exception, DocumentClientException.class));
        if (clientException != null && Exceptions.isStatusCode(clientException, 400) && Exceptions.isSubStatusCode(clientException, 1001) && this.retriesAttempted.get() < 1) {
            this.clientCollectionCache.refresh(this.collectionLink);
            this.retriesAttempted.incrementAndGet();
            return Single.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(Duration.ZERO));
        }
        return this.nextRetryPolicy.shouldRetry(exception);
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.nextRetryPolicy.onBeforeSendRequest(request);
    }
}

