/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import java.time.Duration;
import rx.Single;

public interface IRetryPolicy {
    public Single<ShouldRetryResult> shouldRetry(Exception var1);

    public static class ShouldRetryResult {
        public final Duration backOffTime;
        public final Exception exception;
        public boolean shouldRetry;

        private ShouldRetryResult(Duration dur, Exception e, boolean shouldRetry) {
            this.backOffTime = dur;
            this.exception = e;
            this.shouldRetry = shouldRetry;
        }

        public static ShouldRetryResult retryAfter(Duration dur) {
            Utils.checkNotNullOrThrow((Object)dur, (String)"duration", (String)"cannot be null");
            return new ShouldRetryResult(dur, null, true);
        }

        public static ShouldRetryResult error(Exception e) {
            Utils.checkNotNullOrThrow((Object)e, (String)"exception", (String)"cannot be null");
            return new ShouldRetryResult(null, e, false);
        }

        public static ShouldRetryResult noRetry() {
            return new ShouldRetryResult(null, null, false);
        }
    }
}

