/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.ConnectionPolicy;
import com.microsoft.azure.cosmosdb.DatabaseAccount;
import com.microsoft.azure.cosmosdb.internal.routing.LocationCache;
import com.microsoft.azure.cosmosdb.rx.internal.Configs;
import com.microsoft.azure.cosmosdb.rx.internal.DatabaseAccountManagerInternal;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.routing.LocationHelper;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Completable;
import rx.Observable;
import rx.Scheduler;
import rx.Single;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class GlobalEndpointManager {
    private static final Logger logger = LoggerFactory.getLogger(GlobalEndpointManager.class);
    private final int backgroundRefreshLocationTimeIntervalInMS;
    private final LocationCache locationCache;
    private final URL defaultEndpoint;
    private final ConnectionPolicy connectionPolicy;
    private final DatabaseAccountManagerInternal owner;
    private final AtomicBoolean isRefreshing;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Scheduler scheduler = Schedulers.from((Executor)this.executor);
    private volatile boolean isClosed;

    public GlobalEndpointManager(DatabaseAccountManagerInternal owner, ConnectionPolicy connectionPolicy, Configs configs) {
        this.backgroundRefreshLocationTimeIntervalInMS = configs.getUnavailableLocationsExpirationTimeInSeconds() * 1000;
        try {
            this.locationCache = new LocationCache(new ArrayList<String>(connectionPolicy.getPreferredLocations() != null ? connectionPolicy.getPreferredLocations() : Collections.emptyList()), owner.getServiceEndpoint().toURL(), connectionPolicy.getEnableEndpointDiscovery(), BridgeInternal.getUseMultipleWriteLocations(connectionPolicy), configs);
            this.owner = owner;
            this.defaultEndpoint = owner.getServiceEndpoint().toURL();
            this.connectionPolicy = connectionPolicy;
            this.isRefreshing = new AtomicBoolean(false);
            this.isClosed = false;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.startRefreshLocationTimerAsync(true);
    }

    public UnmodifiableList<URL> getReadEndpoints() {
        return this.locationCache.getReadEndpoints();
    }

    public UnmodifiableList<URL> getWriteEndpoints() {
        return this.locationCache.getWriteEndpoints();
    }

    static Single<DatabaseAccount> getDatabaseAccountFromAnyLocationsAsync(URL defaultEndpoint, List<String> locations, Func1<URL, Single<DatabaseAccount>> getDatabaseAccountFn) {
        return ((Single)getDatabaseAccountFn.call((Object)defaultEndpoint)).onErrorResumeNext(e -> {
            logger.error("Fail to reach global gateway [{}], [{}]", (Object)defaultEndpoint, (Object)e.getMessage());
            if (locations.isEmpty()) {
                return Single.error((Throwable)e);
            }
            Observable obs = Observable.range((int)0, (int)locations.size()).map(index -> ((Single)getDatabaseAccountFn.call((Object)LocationHelper.getLocationEndpoint(defaultEndpoint, (String)locations.get((int)index)))).toObservable());
            Observable res = Observable.concatDelayError((Observable)obs).first().single();
            return res.toSingle().doOnError(innerE -> logger.error("Fail to reach location any of locations", (Object)String.join((CharSequence)",", locations), (Object)innerE.getMessage()));
        });
    }

    public URL resolveServiceEndpoint(RxDocumentServiceRequest request) {
        return this.locationCache.resolveServiceEndpoint(request);
    }

    public void markEndpointUnavailableForRead(URL endpoint) {
        logger.debug("Marking endpoint {} unavailable for read", (Object)endpoint);
        this.locationCache.markEndpointUnavailableForRead(endpoint);
    }

    public void markEndpointUnavailableForWrite(URL endpoint) {
        logger.debug("Marking  endpoint {} unavailable for Write", (Object)endpoint);
        this.locationCache.markEndpointUnavailableForWrite(endpoint);
    }

    public boolean CanUseMultipleWriteLocations(RxDocumentServiceRequest request) {
        return this.locationCache.canUseMultipleWriteLocations(request);
    }

    public void close() {
        this.isClosed = true;
        this.executor.shutdown();
        logger.info("GlobalEndpointManager closed.");
    }

    public Completable refreshLocationAsync(DatabaseAccount databaseAccount) {
        return Completable.defer(() -> {
            logger.debug("refreshLocationAsync() invoked");
            if (!this.isRefreshing.compareAndSet(false, true)) {
                logger.debug("in the middle of another refresh. Not invoking a new refresh.");
                return Completable.complete();
            }
            logger.debug("will refresh");
            return this.refreshLocationPrivateAsync(databaseAccount).doOnError(e -> this.isRefreshing.set(false));
        });
    }

    private Completable refreshLocationPrivateAsync(DatabaseAccount databaseAccount) {
        return Completable.defer(() -> {
            Utils.ValueHolder canRefreshInBackground;
            logger.debug("refreshLocationPrivateAsync() refreshing locations");
            if (databaseAccount != null) {
                this.locationCache.onDatabaseAccountRead(databaseAccount);
            }
            if (this.locationCache.shouldRefreshEndpoints(canRefreshInBackground = new Utils.ValueHolder())) {
                logger.debug("shouldRefreshEndpoints: true");
                if (databaseAccount == null && !((Boolean)canRefreshInBackground.v).booleanValue()) {
                    logger.debug("shouldRefreshEndpoints: can't be done in background");
                    Single<DatabaseAccount> databaseAccountObs = GlobalEndpointManager.getDatabaseAccountFromAnyLocationsAsync(this.defaultEndpoint, new ArrayList<String>(this.connectionPolicy.getPreferredLocations()), (Func1<URL, Single<DatabaseAccount>>)((Func1)url -> this.getDatabaseAccountAsync((URL)url)));
                    return databaseAccountObs.map(dbAccount -> {
                        this.locationCache.onDatabaseAccountRead((DatabaseAccount)dbAccount);
                        return dbAccount;
                    }).flatMapCompletable(dbAccount -> {
                        this.startRefreshLocationTimerAsync();
                        return Completable.complete();
                    });
                }
                this.startRefreshLocationTimerAsync();
                return Completable.complete();
            }
            logger.debug("shouldRefreshEndpoints: false, nothing to do.");
            this.isRefreshing.set(false);
            return Completable.complete();
        });
    }

    private void startRefreshLocationTimerAsync() {
        this.startRefreshLocationTimerAsync(false);
    }

    private void startRefreshLocationTimerAsync(boolean initialization) {
        if (this.isClosed) {
            logger.info("startRefreshLocationTimerAsync: nothing to do, it is closed");
            return;
        }
        logger.debug("registering a refresh in [{}] ms", (Object)this.backgroundRefreshLocationTimeIntervalInMS);
        LocalDateTime now = LocalDateTime.now();
        int delayInMillis = initialization ? 0 : this.backgroundRefreshLocationTimeIntervalInMS;
        Observable.timer((long)delayInMillis, (TimeUnit)TimeUnit.MILLISECONDS).toSingle().flatMapCompletable(t -> {
            if (this.isClosed) {
                logger.warn("client already closed");
                return Completable.error((Throwable)new IllegalStateException("Client already closed"));
            }
            logger.debug("startRefreshLocationTimerAsync() - Invoking refresh, I was registered on [{}]", (Object)now);
            Single databaseAccountObs = GlobalEndpointManager.getDatabaseAccountFromAnyLocationsAsync(this.defaultEndpoint, new ArrayList<String>(this.connectionPolicy.getPreferredLocations()), (Func1<URL, Single<DatabaseAccount>>)((Func1)url -> this.getDatabaseAccountAsync((URL)url))).toObservable().toSingle();
            return databaseAccountObs.flatMapCompletable(dbAccount -> {
                logger.debug("db account retrieved");
                return this.refreshLocationPrivateAsync((DatabaseAccount)dbAccount);
            });
        }).onErrorResumeNext(ex -> {
            logger.error("startRefreshLocationTimerAsync() - Unable to refresh database account from any location. Exception: {}", (Object)ex.toString(), ex);
            this.startRefreshLocationTimerAsync();
            return Completable.complete();
        }).toObservable().subscribeOn(this.scheduler).toBlocking().toFuture();
    }

    private Single<DatabaseAccount> getDatabaseAccountAsync(URL serviceEndpoint) {
        try {
            return this.owner.getDatabaseAccountFromEndpoint(serviceEndpoint.toURI()).doOnNext(i -> logger.debug("account retrieved: {}", i)).toSingle();
        }
        catch (URISyntaxException e) {
            return Single.error((Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

