/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RetryUtils;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import rx.Observable;
import rx.Single;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public class BackoffRetryUtility {
    static Func1<Observable<? extends Throwable>, Observable<Long>> toRetryWhenFunc(final Func1<Exception, Single<Long>> retryFunc, final Action1<Exception> preRetryCallback) {
        return new Func1<Observable<? extends Throwable>, Observable<Long>>(){

            public Observable<Long> call(Observable<? extends Throwable> t) {
                return t.flatMap(f -> {
                    Exception e = (Exception)Utils.as((Object)f, Exception.class);
                    if (e instanceof Exception) {
                        if (preRetryCallback != null) {
                            return ((Single)retryFunc.call((Object)e)).doOnSuccess(v -> preRetryCallback.call((Object)e)).toObservable();
                        }
                        return ((Single)retryFunc.call((Object)e)).toObservable();
                    }
                    return Observable.error((Throwable)f);
                });
            }
        };
    }

    private static <T> Single<T> executeRetry(Func0<Single<T>> callbackMethod, Func1<Exception, Single<Long>> callShouldRetry, Action1<Exception> preRetryCallback) {
        return Single.defer(() -> (Single)callbackMethod.call()).retryWhen(BackoffRetryUtility.toRetryWhenFunc(callShouldRetry, preRetryCallback));
    }

    public static <T> Single<T> executeRetry(Func0<Single<T>> callbackMethod, IRetryPolicy retryPolicy, Action1<Throwable> preRetryCallback) {
        return Single.defer(() -> (Single)callbackMethod.call()).retryWhen(RetryUtils.toRetryWhenFunc(retryPolicy));
    }

    public static <T> Single<T> executeRetry(Func0<Single<T>> callbackMethod, IRetryPolicy retryPolicy) {
        return Single.defer(() -> (Single)callbackMethod.call()).retryWhen(RetryUtils.toRetryWhenFunc(retryPolicy));
    }

    private BackoffRetryUtility() {
    }
}

