/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.query.orderbyquery;

import com.microsoft.azure.cosmosdb.internal.query.ItemComparator;
import com.microsoft.azure.cosmosdb.internal.query.QueryItem;
import com.microsoft.azure.cosmosdb.internal.query.SortOrder;
import com.microsoft.azure.cosmosdb.internal.query.orderbyquery.OrderByRowResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrderbyRowComparer<T>
implements Comparator<OrderByRowResult<T>> {
    private static final Logger logger = LoggerFactory.getLogger(OrderbyRowComparer.class);
    private final List<SortOrder> sortOrders;

    public OrderbyRowComparer(Collection<SortOrder> sortOrders) {
        this.sortOrders = new ArrayList<SortOrder>(sortOrders);
    }

    @Override
    public int compare(OrderByRowResult<T> r1, OrderByRowResult<T> r2) {
        try {
            List<QueryItem> result1 = r1.getOrderByItems();
            List<QueryItem> result2 = r2.getOrderByItems();
            for (int i = 0; i < result1.size(); ++i) {
                int cmp = ItemComparator.getInstance().compare(result1.get(i).getItem(), result2.get(i).getItem());
                if (cmp == 0) continue;
                switch (this.sortOrders.get(i)) {
                    case Ascending: {
                        return cmp;
                    }
                    case Descending: {
                        return -cmp;
                    }
                }
            }
            return r1.getSourcePartitionKeyRange().getMinInclusive().compareTo(r2.getSourcePartitionKeyRange().getMinInclusive());
        }
        catch (Exception e) {
            logger.error("Orderby Row comparision failed {}, {}", new Object[]{r1.toJson(), r2.toJson(), e});
            throw e;
        }
    }
}

