/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("failed to encode {}", (Object)url, (Object)e);
            throw new IllegalArgumentException("failed to encode url " + url, e);
        }
    }

    public static Map<String, String> asMap(HttpResponseHeaders headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : headers.entries()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        return map;
    }

    public static Map<String, String> asSafeMap(HttpResponseHeaders headers) {
        if (headers == null) {
            return Collections.EMPTY_MAP;
        }
        return HttpUtils.asMap(headers);
    }
}

