/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.internal.ISessionToken;
import com.microsoft.azure.cosmosdb.internal.InternalServerErrorException;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.UnmodifiableMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorSessionToken
implements ISessionToken {
    private static final Logger logger = LoggerFactory.getLogger(VectorSessionToken.class);
    private static final char SegmentSeparator = '#';
    private static final char RegionProgressSeparator = '=';
    private final long version;
    private final long globalLsn;
    private final UnmodifiableMap<Integer, Long> localLsnByRegion;
    private String sessionToken;

    private VectorSessionToken(long version, long globalLsn, UnmodifiableMap<Integer, Long> localLsnByRegion) {
        this(version, globalLsn, localLsnByRegion, null);
    }

    private VectorSessionToken(long version, long globalLsn, UnmodifiableMap<Integer, Long> localLsnByRegion, String sessionToken) {
        this.version = version;
        this.globalLsn = globalLsn;
        this.localLsnByRegion = localLsnByRegion;
        this.sessionToken = sessionToken;
        if (this.sessionToken == null) {
            String regionProgress = String.join((CharSequence)Character.toString('#'), localLsnByRegion.entrySet().stream().map(kvp -> String.format("%s%s%s", kvp.getKey(), Character.valueOf('='), kvp.getValue())).collect(Collectors.toList()));
            this.sessionToken = Strings.isNullOrEmpty((String)regionProgress) ? String.format("%s%s%s", this.version, Character.valueOf('#'), this.globalLsn) : String.format("%s%s%s%s%s", this.version, Character.valueOf('#'), this.globalLsn, Character.valueOf('#'), regionProgress);
        }
    }

    public static boolean tryCreate(String sessionToken, Utils.ValueHolder<ISessionToken> parsedSessionToken) {
        Utils.ValueHolder localLsnByRegion;
        Utils.ValueHolder globalLsnHolder;
        Utils.ValueHolder versionHolder = Utils.ValueHolder.initialize((Object)-1L);
        if (VectorSessionToken.tryParseSessionToken(sessionToken, (Utils.ValueHolder<Long>)versionHolder, (Utils.ValueHolder<Long>)(globalLsnHolder = Utils.ValueHolder.initialize((Object)-1L)), (Utils.ValueHolder<UnmodifiableMap<Integer, Long>>)(localLsnByRegion = Utils.ValueHolder.initialize(null)))) {
            parsedSessionToken.v = new VectorSessionToken((Long)versionHolder.v, (Long)globalLsnHolder.v, (UnmodifiableMap<Integer, Long>)((UnmodifiableMap)localLsnByRegion.v), sessionToken);
            return true;
        }
        return false;
    }

    public long getLSN() {
        return this.globalLsn;
    }

    public boolean equals(Object obj) {
        VectorSessionToken other = (VectorSessionToken)Utils.as((Object)obj, VectorSessionToken.class);
        if (other == null) {
            return false;
        }
        return this.version == other.version && this.globalLsn == other.globalLsn && this.areRegionProgressEqual(other.localLsnByRegion);
    }

    public boolean isValid(ISessionToken otherSessionToken) throws DocumentClientException {
        VectorSessionToken other = (VectorSessionToken)Utils.as((Object)otherSessionToken, VectorSessionToken.class);
        if (other == null) {
            throw new IllegalArgumentException("otherSessionToken");
        }
        if (other.version < this.version || other.globalLsn < this.globalLsn) {
            return false;
        }
        if (other.version == this.version && other.localLsnByRegion.size() != this.localLsnByRegion.size()) {
            throw new InternalServerErrorException(String.format("Compared session tokens '%s' and '%s' has unexpected regions.", this.sessionToken, other.sessionToken));
        }
        for (Map.Entry kvp : other.localLsnByRegion.entrySet()) {
            Integer regionId = (Integer)kvp.getKey();
            long otherLocalLsn = (Long)kvp.getValue();
            Utils.ValueHolder localLsn = Utils.ValueHolder.initialize((Object)-1L);
            if (!Utils.tryGetValue(this.localLsnByRegion, (Object)regionId, (Utils.ValueHolder)localLsn)) {
                if (this.version != other.version) continue;
                throw new InternalServerErrorException(String.format("Compared session tokens '%s' and '%s' has unexpected regions.", this.sessionToken, other.sessionToken));
            }
            if (otherLocalLsn >= (Long)localLsn.v) continue;
            return false;
        }
        return true;
    }

    public ISessionToken merge(ISessionToken obj) throws DocumentClientException {
        VectorSessionToken sessionTokenWithHigherVersion;
        VectorSessionToken sessionTokenWithLowerVersion;
        VectorSessionToken other = (VectorSessionToken)Utils.as((Object)obj, VectorSessionToken.class);
        if (other == null) {
            throw new IllegalArgumentException("obj");
        }
        if (this.version == other.version && this.localLsnByRegion.size() != other.localLsnByRegion.size()) {
            throw new InternalServerErrorException(String.format("Compared session tokens '%s' and '%s' has unexpected regions.", this.sessionToken, other.sessionToken));
        }
        if (this.version < other.version) {
            sessionTokenWithLowerVersion = this;
            sessionTokenWithHigherVersion = other;
        } else {
            sessionTokenWithLowerVersion = other;
            sessionTokenWithHigherVersion = this;
        }
        HashMap<Integer, Long> highestLocalLsnByRegion = new HashMap<Integer, Long>();
        for (Map.Entry kvp : sessionTokenWithHigherVersion.localLsnByRegion.entrySet()) {
            Integer regionId = (Integer)kvp.getKey();
            long localLsn1 = (Long)kvp.getValue();
            Utils.ValueHolder localLsn2 = Utils.ValueHolder.initialize((Object)-1L);
            if (Utils.tryGetValue(sessionTokenWithLowerVersion.localLsnByRegion, (Object)regionId, (Utils.ValueHolder)localLsn2)) {
                highestLocalLsnByRegion.put(regionId, Math.max(localLsn1, (Long)localLsn2.v));
                continue;
            }
            if (this.version == other.version) {
                throw new InternalServerErrorException(String.format("Compared session tokens '%s' and '%s' has unexpected regions.", this.sessionToken, other.sessionToken));
            }
            highestLocalLsnByRegion.put(regionId, localLsn1);
        }
        return new VectorSessionToken(Math.max(this.version, other.version), Math.max(this.globalLsn, other.globalLsn), (UnmodifiableMap<Integer, Long>)((UnmodifiableMap)UnmodifiableMap.unmodifiableMap(highestLocalLsnByRegion)));
    }

    public String convertToString() {
        return this.sessionToken;
    }

    private boolean areRegionProgressEqual(UnmodifiableMap<Integer, Long> other) {
        if (this.localLsnByRegion.size() != other.size()) {
            return false;
        }
        for (Map.Entry kvp : this.localLsnByRegion.entrySet()) {
            Integer regionId = (Integer)kvp.getKey();
            Utils.ValueHolder localLsn1 = Utils.ValueHolder.initialize(kvp.getValue());
            Utils.ValueHolder localLsn2 = Utils.ValueHolder.initialize((Object)-1L);
            if (!Utils.tryGetValue(other, (Object)regionId, (Utils.ValueHolder)localLsn2) || !ObjectUtils.notEqual((Object)localLsn1.v, (Object)localLsn2.v)) continue;
            return false;
        }
        return true;
    }

    private static boolean tryParseSessionToken(String sessionToken, Utils.ValueHolder<Long> version, Utils.ValueHolder<Long> globalLsn, Utils.ValueHolder<UnmodifiableMap<Integer, Long>> localLsnByRegion) {
        version.v = 0L;
        localLsnByRegion.v = null;
        globalLsn.v = -1L;
        if (Strings.isNullOrEmpty((String)sessionToken)) {
            logger.warn("Session token is empty");
            return false;
        }
        String[] segments = StringUtils.split((String)sessionToken, (char)'#');
        if (segments.length < 2) {
            return false;
        }
        if (!VectorSessionToken.tryParseLong(segments[0], version) || !VectorSessionToken.tryParseLong(segments[1], globalLsn)) {
            logger.warn("Unexpected session token version number '{}' OR global lsn '{}'.", (Object)segments[0], (Object)segments[1]);
            return false;
        }
        HashMap<Object, Object> lsnByRegion = new HashMap<Object, Object>();
        for (int i = 2; i < segments.length; ++i) {
            String regionSegment = segments[i];
            String[] regionIdWithLsn = StringUtils.split((String)regionSegment, (char)'=');
            if (regionIdWithLsn.length != 2) {
                logger.warn("Unexpected region progress segment length '{}' in session token.", (Object)regionIdWithLsn.length);
                return false;
            }
            Utils.ValueHolder regionId = Utils.ValueHolder.initialize((Object)0);
            Utils.ValueHolder localLsn = Utils.ValueHolder.initialize((Object)-1L);
            if (!VectorSessionToken.tryParseInt(regionIdWithLsn[0], (Utils.ValueHolder<Integer>)regionId) || !VectorSessionToken.tryParseLong(regionIdWithLsn[1], (Utils.ValueHolder<Long>)localLsn)) {
                logger.warn("Unexpected region progress '{}' for region '{}' in session token.", (Object)regionIdWithLsn[0], (Object)regionIdWithLsn[1]);
                return false;
            }
            lsnByRegion.put(regionId.v, localLsn.v);
        }
        localLsnByRegion.v = (UnmodifiableMap)UnmodifiableMap.unmodifiableMap(lsnByRegion);
        return true;
    }

    private static boolean tryParseLong(String str, Utils.ValueHolder<Long> value) {
        try {
            value.v = Long.parseLong(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean tryParseInt(String str, Utils.ValueHolder<Integer> value) {
        try {
            value.v = Integer.parseInt(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

