/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.internal.ISessionToken;
import com.microsoft.azure.cosmosdb.internal.SessionContainer;
import com.microsoft.azure.cosmosdb.internal.VectorSessionToken;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class SessionTokenHelper {
    public static void setPartitionLocalSessionToken(RxDocumentServiceRequest request, SessionContainer sessionContainer) throws DocumentClientException {
        String originalSessionToken = (String)request.getHeaders().get("x-ms-session-token");
        String partitionKeyRangeId = request.requestContext.resolvedPartitionKeyRange.getId();
        if (StringUtils.isNotEmpty((CharSequence)originalSessionToken)) {
            ISessionToken sessionLsn = SessionTokenHelper.getLocalSessionToken(request, originalSessionToken, partitionKeyRangeId);
            if (sessionLsn != null) {
                request.requestContext.sessionToken = sessionLsn;
            }
        } else {
            ISessionToken sessionLsn = sessionContainer.resolvePartitionLocalSessionToken(request, partitionKeyRangeId);
            if (sessionLsn != null) {
                request.requestContext.sessionToken = sessionLsn;
            }
        }
        if (request.requestContext.sessionToken == null) {
            request.getHeaders().remove("x-ms-session-token");
        } else {
            request.getHeaders().put("x-ms-session-token", String.format("%1s:%2s", "0", request.requestContext.sessionToken.convertToString()));
        }
    }

    private static ISessionToken getLocalSessionToken(RxDocumentServiceRequest request, String sessionToken, String partitionKeyRangeId) throws DocumentClientException {
        if (partitionKeyRangeId == null || partitionKeyRangeId.isEmpty()) {
            throw new IllegalStateException("Partition key range Id is absent in the context.");
        }
        String[] localTokens = sessionToken.split(",");
        HashSet<String> partitionKeyRangeSet = new HashSet<String>();
        partitionKeyRangeSet.add(partitionKeyRangeId);
        if (request.requestContext.resolvedPartitionKeyRange != null && request.requestContext.resolvedPartitionKeyRange.getParents() != null) {
            partitionKeyRangeSet.addAll(request.requestContext.resolvedPartitionKeyRange.getParents());
        }
        ISessionToken highestSessionToken = null;
        for (String localToken : localTokens) {
            String[] items = localToken.split(":");
            if (items.length != 2) {
                throw new DocumentClientException(400, "Invalid session token value.");
            }
            if (!partitionKeyRangeSet.contains(items[0])) continue;
            ISessionToken parsedSessionToken = SessionTokenHelper.parse(items[1]);
            highestSessionToken = highestSessionToken == null ? parsedSessionToken : highestSessionToken.merge(parsedSessionToken);
        }
        return highestSessionToken;
    }

    static ISessionToken resolvePartitionLocalSessionToken(RxDocumentServiceRequest request, String partitionKeyRangeId, ConcurrentHashMap<String, ISessionToken> rangeIdToTokenMap) {
        if (rangeIdToTokenMap != null) {
            if (rangeIdToTokenMap.containsKey(partitionKeyRangeId)) {
                return rangeIdToTokenMap.get(partitionKeyRangeId);
            }
            Collection parents = request.requestContext.resolvedPartitionKeyRange.getParents();
            if (parents != null) {
                ArrayList parentsList = new ArrayList(parents);
                for (int i = parentsList.size() - 1; i >= 0; --i) {
                    String parentId = (String)parentsList.get(i);
                    if (!rangeIdToTokenMap.containsKey(parentId)) continue;
                    return rangeIdToTokenMap.get(parentId);
                }
            }
        }
        return null;
    }

    public static ISessionToken resolvePartitionLocalSessionToken(RxDocumentServiceRequest request, String partitionKeyRangeId, SessionContainer sessionContainer) throws DocumentClientException {
        return sessionContainer.resolvePartitionLocalSessionToken(request, partitionKeyRangeId);
    }

    static ISessionToken parse(String sessionToken) {
        Utils.ValueHolder partitionKeyRangeSessionToken = Utils.ValueHolder.initialize(null);
        if (VectorSessionToken.tryCreate(sessionToken, (Utils.ValueHolder<ISessionToken>)partitionKeyRangeSessionToken)) {
            return (ISessionToken)partitionKeyRangeSessionToken.v;
        }
        throw new IllegalArgumentException(String.format("The session token provided '%s' is invalid.", sessionToken));
    }
}

