/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.internal.ISessionToken;
import com.microsoft.azure.cosmosdb.internal.PathInfo;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceId;
import com.microsoft.azure.cosmosdb.internal.SessionTokenHelper;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public final class SessionContainer {
    private final ConcurrentHashMap<Long, ConcurrentHashMap<String, ISessionToken>> collectionResourceIdToSessionTokens;
    private final ConcurrentHashMap<String, Long> collectionNameToCollectionResourceId;
    private final String hostName;

    public SessionContainer(String hostName) {
        this(hostName, new ConcurrentHashMap<String, Long>(), new ConcurrentHashMap<Long, ConcurrentHashMap<String, ISessionToken>>());
    }

    public SessionContainer(String hostName, ConcurrentHashMap<String, Long> nameToRidMap, ConcurrentHashMap<Long, ConcurrentHashMap<String, ISessionToken>> ridToTokensMap) {
        this.hostName = hostName;
        this.collectionResourceIdToSessionTokens = ridToTokensMap;
        this.collectionNameToCollectionResourceId = nameToRidMap;
    }

    public String getHostName() {
        return this.hostName;
    }

    private ConcurrentHashMap<String, ISessionToken> getPartitionKeyRangeIdToTokenMap(RxDocumentServiceRequest request) {
        return this.getPartitionKeyRangeIdToTokenMap(request.getIsNameBased(), request.getResourceId(), request.getResourceAddress());
    }

    private ConcurrentHashMap<String, ISessionToken> getPartitionKeyRangeIdToTokenMap(boolean isNameBased, String rId, String resourceAddress) {
        ConcurrentHashMap<String, ISessionToken> rangeIdToTokenMap = null;
        if (!isNameBased) {
            ResourceId resourceId;
            if (!StringUtils.isEmpty((CharSequence)rId) && (resourceId = ResourceId.parse((String)rId)).getDocumentCollection() != 0) {
                rangeIdToTokenMap = this.collectionResourceIdToSessionTokens.get(resourceId.getUniqueDocumentCollectionId());
            }
        } else {
            String collectionName = Utils.getCollectionName((String)resourceAddress);
            if (!StringUtils.isEmpty((CharSequence)collectionName) && this.collectionNameToCollectionResourceId.containsKey(collectionName)) {
                rangeIdToTokenMap = this.collectionResourceIdToSessionTokens.get(this.collectionNameToCollectionResourceId.get(collectionName));
            }
        }
        return rangeIdToTokenMap;
    }

    public String resolveGlobalSessionToken(RxDocumentServiceRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        return this.resolveGlobalSessionToken(request.getIsNameBased(), request.getResourceId(), request.getResourceAddress());
    }

    private String resolveGlobalSessionToken(boolean isNameBased, String rId, String resourceAddress) {
        ConcurrentHashMap<String, ISessionToken> rangeIdToTokenMap = this.getPartitionKeyRangeIdToTokenMap(isNameBased, rId, resourceAddress);
        if (rangeIdToTokenMap != null) {
            return this.getCombinedSessionToken(rangeIdToTokenMap);
        }
        return "";
    }

    public String resolveGlobalSessionToken(String collectionLink) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink cannot be null");
        }
        PathInfo pathInfo = PathsHelper.parsePathSegments((String)collectionLink);
        if (pathInfo == null) {
            return "";
        }
        return this.resolveGlobalSessionToken(pathInfo.isNameBased, pathInfo.resourceIdOrFullName, pathInfo.resourcePath);
    }

    public void clearToken(RxDocumentServiceRequest request) {
        Long collectionResourceId = null;
        if (!request.getIsNameBased()) {
            ResourceId resourceId;
            if (!StringUtils.isEmpty((CharSequence)request.getResourceId()) && (resourceId = ResourceId.parse((String)request.getResourceId())).getDocumentCollection() != 0) {
                collectionResourceId = resourceId.getUniqueDocumentCollectionId();
            }
        } else {
            String collectionName = Utils.getCollectionName((String)request.getResourceAddress());
            if (!StringUtils.isEmpty((CharSequence)collectionName)) {
                collectionResourceId = this.collectionNameToCollectionResourceId.get(collectionName);
                this.collectionNameToCollectionResourceId.remove(collectionName);
            }
        }
        if (collectionResourceId != null) {
            this.collectionResourceIdToSessionTokens.remove(collectionResourceId);
        }
    }

    public void setSessionToken(RxDocumentServiceRequest request, RxDocumentServiceResponse response) {
        String sessionToken;
        if (response != null && !request.isReadingFromMaster() && !StringUtils.isEmpty((CharSequence)(sessionToken = (String)response.getResponseHeaders().get("x-ms-session-token")))) {
            ResourceId resourceId;
            String ownerId;
            String ownerFullName = (String)response.getResponseHeaders().get("x-ms-alt-content-path");
            if (StringUtils.isEmpty((CharSequence)ownerFullName)) {
                ownerFullName = request.getResourceAddress();
            }
            String collectionName = Utils.getCollectionName((String)ownerFullName);
            if (!request.getIsNameBased()) {
                ownerId = request.getResourceId();
            } else {
                ownerId = (String)response.getResponseHeaders().get("x-ms-content-path");
                if (StringUtils.isEmpty((CharSequence)ownerId)) {
                    ownerId = request.getResourceId();
                }
            }
            if (!StringUtils.isEmpty((CharSequence)ownerId) && (resourceId = ResourceId.parse((String)ownerId)).getDocumentCollection() != 0 && !StringUtils.isEmpty((CharSequence)collectionName)) {
                Long uniqueDocumentCollectionId = resourceId.getUniqueDocumentCollectionId();
                this.setSessionToken(uniqueDocumentCollectionId, collectionName, sessionToken);
            }
        }
    }

    private void setSessionToken(long collectionRid, String collectionName, String sessionToken) {
        this.collectionResourceIdToSessionTokens.putIfAbsent(collectionRid, new ConcurrentHashMap());
        this.compareAndSetToken(sessionToken, this.collectionResourceIdToSessionTokens.get(collectionRid));
        this.collectionNameToCollectionResourceId.putIfAbsent(collectionName, collectionRid);
    }

    private String getCombinedSessionToken(ConcurrentHashMap<String, ISessionToken> tokens) {
        StringBuilder result = new StringBuilder();
        if (tokens != null) {
            Iterator<Map.Entry<String, ISessionToken>> iterator = tokens.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ISessionToken> entry = iterator.next();
                result = result.append(entry.getKey()).append(":").append(entry.getValue().convertToString());
                if (!iterator.hasNext()) continue;
                result = result.append(",");
            }
        }
        return result.toString();
    }

    private void compareAndSetToken(String newToken, ConcurrentHashMap<String, ISessionToken> oldTokens) {
        if (StringUtils.isNotEmpty((CharSequence)newToken)) {
            String[] newTokenParts = newToken.split(":");
            if (newTokenParts.length == 2) {
                String range = newTokenParts[0];
                ISessionToken newLSN = SessionTokenHelper.parse(newTokenParts[1]);
                oldTokens.merge(range, newLSN, (oldSessionToken, newSessionToken) -> {
                    try {
                        if (oldSessionToken == null) {
                            return newSessionToken;
                        }
                        return oldSessionToken.merge(newSessionToken);
                    }
                    catch (DocumentClientException e) {
                        throw new IllegalStateException(e);
                    }
                });
            } else assert (false) : "service returned an invalid session token";
        }
    }

    ISessionToken resolvePartitionLocalSessionToken(RxDocumentServiceRequest request, String partitionKeyRangeId) {
        return SessionTokenHelper.resolvePartitionLocalSessionToken(request, partitionKeyRangeId, this.getPartitionKeyRangeIdToTokenMap(request));
    }
}

