/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.cosmosdb.ChangeFeedOptions;
import com.microsoft.azure.cosmosdb.ConnectionPolicy;
import com.microsoft.azure.cosmosdb.DatabaseAccount;
import com.microsoft.azure.cosmosdb.Document;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedOptionsBase;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.MediaResponse;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.ResourceResponse;
import com.microsoft.azure.cosmosdb.StoredProcedureResponse;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BridgeInternal {
    public static Document documentFromObject(Object document, ObjectMapper mapper) {
        return Document.FromObject((Object)document, (ObjectMapper)mapper);
    }

    public static <T extends Resource> ResourceResponse<T> toResourceResponse(RxDocumentServiceResponse response, Class<T> cls) {
        return new ResourceResponse(response, cls);
    }

    public static <T extends Resource> MediaResponse toMediaResponse(RxDocumentServiceResponse response, boolean willBuffer) {
        return new MediaResponse(response, willBuffer);
    }

    public static <T extends Resource> FeedResponse<T> toFeedResponsePage(RxDocumentServiceResponse response, Class<T> cls) {
        return new FeedResponse(response.getQueryResponse(cls), response.getResponseHeaders());
    }

    public static <T extends Resource> FeedResponse<T> toChaneFeedResponsePage(RxDocumentServiceResponse response, Class<T> cls) {
        return new FeedResponse(BridgeInternal.noChanges(response) ? Collections.emptyList() : response.getQueryResponse(cls), response.getResponseHeaders(), BridgeInternal.noChanges(response));
    }

    public static StoredProcedureResponse toStoredProcedureResponse(RxDocumentServiceResponse response) {
        return new StoredProcedureResponse(response);
    }

    public static DatabaseAccount toDatabaseAccount(RxDocumentServiceResponse response) {
        DatabaseAccount account = (DatabaseAccount)response.getResource(DatabaseAccount.class);
        Map responseHeader = response.getResponseHeaders();
        account.setMaxMediaStorageUsageInMB(Long.valueOf((String)responseHeader.get("x-ms-max-media-storage-usage-mb")).longValue());
        account.setMediaStorageUsageInMB(Long.valueOf((String)responseHeader.get("x-ms-media-storage-usage-mb")).longValue());
        return account;
    }

    public static Map<String, String> getFeedHeaders(FeedOptionsBase options) {
        FeedOptions feedOptions;
        if (options == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (options.getMaxItemCount() != null) {
            headers.put("x-ms-max-item-count", options.getMaxItemCount().toString());
        }
        if (options instanceof ChangeFeedOptions) {
            ChangeFeedOptions changeFeedOptions = (ChangeFeedOptions)options;
            String ifNoneMatchValue = null;
            if (changeFeedOptions.getRequestContinuation() != null) {
                ifNoneMatchValue = changeFeedOptions.getRequestContinuation();
            } else if (!changeFeedOptions.isStartFromBeginning()) {
                ifNoneMatchValue = "*";
            }
            if (ifNoneMatchValue != null) {
                headers.put("If-None-Match", ifNoneMatchValue);
            }
            headers.put("A-IM", "Incremental feed");
        } else if (options.getRequestContinuation() != null) {
            headers.put("x-ms-continuation", options.getRequestContinuation());
        }
        FeedOptions feedOptions2 = feedOptions = options instanceof FeedOptions ? (FeedOptions)options : null;
        if (feedOptions != null) {
            if (feedOptions.getSessionToken() != null) {
                headers.put("x-ms-session-token", feedOptions.getSessionToken());
            }
            if (feedOptions.getEnableScanInQuery() != null) {
                headers.put("x-ms-documentdb-query-enable-scan", feedOptions.getEnableScanInQuery().toString());
            }
            if (feedOptions.getEmitVerboseTracesInQuery() != null) {
                headers.put("x-ms-documentdb-query-emit-traces", feedOptions.getEmitVerboseTracesInQuery().toString());
            }
            if (feedOptions.getEnableCrossPartitionQuery() != null) {
                headers.put("x-ms-documentdb-query-enablecrosspartition", feedOptions.getEnableCrossPartitionQuery().toString());
            }
            if (feedOptions.getMaxDegreeOfParallelism() != 0) {
                headers.put("x-ms-documentdb-query-parallelizecrosspartitionquery", Boolean.TRUE.toString());
            }
            if (feedOptions.getResponseContinuationTokenLimitInKb() > 0) {
                headers.put("x-ms-documentdb-responsecontinuationtokenlimitinkb", Strings.toString((int)feedOptions.getResponseContinuationTokenLimitInKb()));
            }
        }
        return headers;
    }

    public static <T extends Resource> boolean noChanges(FeedResponse<T> page) {
        return page.nochanges;
    }

    public static <T extends Resource> boolean noChanges(RxDocumentServiceResponse rsp) {
        return rsp.getStatusCode() == 304;
    }

    public static <T extends Resource> FeedResponse<T> createFeedResponse(List<T> results, Map<String, String> headers) {
        return new FeedResponse(results, headers);
    }

    public static boolean isEnableMultipleWriteLocations(DatabaseAccount account) {
        return account.isEnableMultipleWriteLocations();
    }

    public static boolean getUseMultipleWriteLocations(ConnectionPolicy policy) {
        return policy.isUsingMultipleWriteLocations();
    }

    public static void setUseMultipleWriteLocations(ConnectionPolicy policy, boolean value) {
        policy.setUsingMultipleWriteLocations(value);
    }
}

