/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.httputils;

import com.microsoft.applicationinsights.internal.agent.AgentBinding;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.web.dependencies.apachecommons.lang3.Validate;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.httputils.HttpServerHandler;
import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public final class AIHttpServletListener
implements AsyncListener {
    private final RequestTelemetryContext context;
    private final HttpServerHandler handler;
    private final AgentBinding agentBinding;

    public AIHttpServletListener(HttpServerHandler handler, RequestTelemetryContext context) {
        this(handler, context, null);
    }

    public AIHttpServletListener(HttpServerHandler handler, RequestTelemetryContext context, AgentBinding agentBinding) {
        Validate.notNull(handler, "HttpServerHandler", new Object[0]);
        Validate.notNull(context, "RequestTelemetryContext", new Object[0]);
        this.handler = handler;
        this.context = context;
        this.agentBinding = agentBinding;
    }

    public void onComplete(AsyncEvent event) {
        ServletRequest request = event.getSuppliedRequest();
        ServletResponse response = event.getSuppliedResponse();
        this.handler.handleEnd(request, response, this.context);
        if (this.agentBinding != null) {
            this.agentBinding.unbindFromRunawayChildThreads();
        }
    }

    public void onTimeout(AsyncEvent event) {
        ServletRequest request = event.getSuppliedRequest();
        ServletResponse response = event.getSuppliedResponse();
        this.handler.handleEnd(request, response, this.context);
        if (this.agentBinding != null) {
            this.agentBinding.unbindFromRunawayChildThreads();
        }
    }

    public void onError(AsyncEvent event) {
        ServletRequest request = event.getSuppliedRequest();
        ServletResponse response = event.getSuppliedResponse();
        Throwable throwable = event.getThrowable();
        if (throwable instanceof Exception) {
            this.handler.handleException((Exception)throwable);
        } else {
            InternalLogger.INSTANCE.warn("Throwable is not instance of exception, cannot be captured: %s", throwable);
        }
        request.setAttribute("AI_CAUGHT_EXCEPTION", (Object)throwable);
        this.handler.handleEnd(request, response, this.context);
        if (this.agentBinding != null) {
            this.agentBinding.unbindFromRunawayChildThreads();
        }
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
        AsyncContext asyncContext = event.getAsyncContext();
        if (asyncContext != null) {
            asyncContext.addListener((AsyncListener)this, event.getSuppliedRequest(), event.getSuppliedResponse());
        }
    }
}

