/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.extensibility.initializers;

import com.microsoft.applicationinsights.common.CommonUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.web.extensibility.initializers.WebTelemetryInitializerBase;
import com.microsoft.applicationinsights.web.internal.RequestTelemetryContext;
import com.microsoft.applicationinsights.web.internal.ThreadContext;
import java.util.Map;

public class WebOperationIdTelemetryInitializer
extends WebTelemetryInitializerBase {
    @Override
    protected void onInitializeTelemetry(Telemetry telemetry) {
        RequestTelemetryContext telemetryContext = ThreadContext.getRequestTelemetryContext();
        if (telemetryContext == null) {
            InternalLogger.INSTANCE.error("Unexpected error. No telemetry context found. OperationContext will not be initialized.", new Object[0]);
            return;
        }
        RequestTelemetry requestTelemetry = telemetryContext.getHttpRequestTelemetry();
        String currentOperationId = requestTelemetry.getContext().getOperation().getId();
        if (currentOperationId == null || currentOperationId.isEmpty()) {
            telemetry.getContext().getOperation().setId(requestTelemetry.getId());
            return;
        }
        if (CommonUtils.isNullOrEmpty(telemetry.getContext().getOperation().getId())) {
            telemetry.getContext().getOperation().setId(currentOperationId);
        }
        if (telemetry != requestTelemetry && CommonUtils.isNullOrEmpty(telemetry.getContext().getOperation().getParentId())) {
            telemetry.getContext().getOperation().setParentId(requestTelemetry.getId());
        }
        Map<String, String> correlationContextMap = telemetryContext.getCorrelationContext().getMappings();
        for (Map.Entry<String, String> entry : correlationContextMap.entrySet()) {
            if (telemetry.getProperties().get(entry.getKey()) != null) continue;
            telemetry.getProperties().put(entry.getKey(), entry.getValue());
        }
    }
}

