/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights;

import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.channel.concrete.nop.NopTelemetryChannel;
import com.microsoft.applicationinsights.core.dependencies.google.common.annotations.VisibleForTesting;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Strings;
import com.microsoft.applicationinsights.extensibility.ContextInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryModule;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.internal.config.TelemetryConfigurationFactory;
import com.microsoft.applicationinsights.internal.config.connection.ConnectionString;
import com.microsoft.applicationinsights.internal.config.connection.EndpointProvider;
import com.microsoft.applicationinsights.internal.config.connection.InvalidConnectionStringException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class TelemetryConfiguration {
    private static final Object s_lock = new Object();
    private static volatile TelemetryConfiguration active;
    private String instrumentationKey;
    private String connectionString;
    private String roleName;
    private final EndpointProvider endpointProvider = new EndpointProvider();
    private final List<ContextInitializer> contextInitializers = new CopyOnWriteArrayList<ContextInitializer>();
    private final List<TelemetryInitializer> telemetryInitializers = new CopyOnWriteArrayList<TelemetryInitializer>();
    private final List<TelemetryModule> telemetryModules = new CopyOnWriteArrayList<TelemetryModule>();
    private final List<TelemetryProcessor> telemetryProcessors = new CopyOnWriteArrayList<TelemetryProcessor>();
    private TelemetryChannel channel;
    private boolean trackingIsDisabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TelemetryConfiguration getActive() {
        if (active == null) {
            Object object = s_lock;
            synchronized (object) {
                if (active == null) {
                    active = TelemetryConfiguration.createDefault();
                }
            }
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TelemetryConfiguration getActiveWithoutInitializingConfig() {
        if (active == null) {
            Object object = s_lock;
            synchronized (object) {
                if (active == null) {
                    active = new TelemetryConfiguration();
                }
            }
        }
        return active;
    }

    public static TelemetryConfiguration createDefault() {
        TelemetryConfiguration telemetryConfiguration = new TelemetryConfiguration();
        TelemetryConfigurationFactory.INSTANCE.initialize(telemetryConfiguration);
        return telemetryConfiguration;
    }

    public synchronized TelemetryChannel getChannel() {
        if (this.channel == null) {
            return NopTelemetryChannel.instance();
        }
        return this.channel;
    }

    public synchronized void setChannel(TelemetryChannel channel) {
        this.channel = channel;
    }

    public boolean isTrackingDisabled() {
        return this.trackingIsDisabled;
    }

    public void setTrackingIsDisabled(boolean disable) {
        this.trackingIsDisabled = disable;
    }

    public List<ContextInitializer> getContextInitializers() {
        return this.contextInitializers;
    }

    public List<TelemetryInitializer> getTelemetryInitializers() {
        return this.telemetryInitializers;
    }

    public List<TelemetryModule> getTelemetryModules() {
        return this.telemetryModules;
    }

    public List<TelemetryProcessor> getTelemetryProcessors() {
        return this.telemetryProcessors;
    }

    public String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    public void setInstrumentationKey(String key) {
        if (Strings.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("key");
        }
        this.instrumentationKey = key;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        try {
            ConnectionString.parseInto(connectionString, this);
        }
        catch (InvalidConnectionStringException e) {
            throw new IllegalArgumentException("Invalid connection string", e);
        }
        this.connectionString = connectionString;
    }

    public EndpointProvider getEndpointProvider() {
        return this.endpointProvider;
    }

    @VisibleForTesting
    static void setActiveAsNull() {
        active = null;
    }
}

