/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.boot.dependencies.apachecommons.io.input;

import com.microsoft.applicationinsights.boot.dependencies.apachecommons.io.TaggedIOException;
import com.microsoft.applicationinsights.boot.dependencies.apachecommons.io.input.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;

public class TaggedInputStream
extends ProxyInputStream {
    private final Serializable tag = UUID.randomUUID();

    public TaggedInputStream(InputStream proxy) {
        super(proxy);
    }

    public boolean isCauseOf(Throwable exception) {
        return TaggedIOException.isTaggedWith(exception, this.tag);
    }

    public void throwIfCauseOf(Throwable throwable) throws IOException {
        TaggedIOException.throwCauseIfTaggedWith(throwable, this.tag);
    }

    @Override
    protected void handleIOException(IOException e) throws IOException {
        throw new TaggedIOException(e, this.tag);
    }
}

