/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.cfg;

import com.mchange.v1.xml.DomParseUtils;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.cfg.C3P0ConfigUtils;
import com.mchange.v2.c3p0.cfg.NamedScope;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class C3P0ConfigXmlUtils {
    public static final String XML_CONFIG_RSRC_PATH = "/c3p0-config.xml";
    static final MLogger logger;
    public static final String LINESEP;
    private static final String[] MISSPELL_PFXS;
    private static final char[] MISSPELL_LINES;
    private static final String[] MISSPELL_CONFIG;
    private static final String[] MISSPELL_XML;

    private static final void warnCommonXmlConfigResourceMisspellings() {
        if (logger.isLoggable(MLevel.WARNING)) {
            int n = MISSPELL_PFXS.length;
            for (int i = 0; i < n; ++i) {
                StringBuffer stringBuffer = new StringBuffer(16);
                stringBuffer.append(MISSPELL_PFXS[i]);
                int n2 = MISSPELL_LINES.length;
                for (int j = 0; j < n2; ++j) {
                    stringBuffer.append(MISSPELL_LINES[j]);
                    int n3 = MISSPELL_CONFIG.length;
                    for (int k = 0; k < n3; ++k) {
                        stringBuffer.append(MISSPELL_CONFIG[k]);
                        stringBuffer.append('.');
                        int n4 = MISSPELL_XML.length;
                        for (int i2 = 0; i2 < n4; ++i2) {
                            URL uRL;
                            stringBuffer.append(MISSPELL_XML[i2]);
                            String string = stringBuffer.toString();
                            if (string.equals(XML_CONFIG_RSRC_PATH) || (uRL = C3P0ConfigXmlUtils.class.getResource(string)) == null) continue;
                            logger.warning("POSSIBLY MISSPELLED c3p0-conf.xml RESOURCE FOUND. Please ensure the file name is c3p0-config.xml, all lower case, with the digit 0 (NOT the letter O) in c3p0. It should be placed  in the top level of c3p0's effective classpath.");
                            return;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static C3P0Config extractXmlConfigFromDefaultResource(boolean bl) throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = C3P0ConfigUtils.class.getResourceAsStream(XML_CONFIG_RSRC_PATH);
            if (inputStream == null) {
                C3P0Config c3P0Config = null;
                return c3P0Config;
            }
            C3P0Config c3P0Config = C3P0ConfigXmlUtils.extractXmlConfigFromInputStream(inputStream, bl);
            return c3P0Config;
        }
        finally {
            block12: {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(MLevel.FINE)) break block12;
                    logger.log(MLevel.FINE, "Exception on resource InputStream close.", (Throwable)exception);
                }
            }
        }
    }

    private static void attemptSetFeature(DocumentBuilderFactory documentBuilderFactory, String string, boolean bl) {
        block2: {
            try {
                documentBuilderFactory.setFeature(string, bl);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (!logger.isLoggable(MLevel.FINE)) break block2;
                logger.log(MLevel.FINE, "Attempted but failed to set presumably unsupported feature '" + string + "' to " + bl + ".");
            }
        }
    }

    private static void cautionDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        C3P0ConfigXmlUtils.attemptSetFeature(documentBuilderFactory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        C3P0ConfigXmlUtils.attemptSetFeature(documentBuilderFactory, "http://xerces.apache.org/xerces-j/features.html#external-general-entities", false);
        C3P0ConfigXmlUtils.attemptSetFeature(documentBuilderFactory, "http://xerces.apache.org/xerces2-j/features.html#external-general-entities", false);
        C3P0ConfigXmlUtils.attemptSetFeature(documentBuilderFactory, "http://xml.org/sax/features/external-general-entities", false);
        C3P0ConfigXmlUtils.attemptSetFeature(documentBuilderFactory, "http://xerces.apache.org/xerces-j/features.html#external-parameter-entities", false);
        C3P0ConfigXmlUtils.attemptSetFeature(documentBuilderFactory, "http://xerces.apache.org/xerces2-j/features.html#external-parameter-entities", false);
        C3P0ConfigXmlUtils.attemptSetFeature(documentBuilderFactory, "http://xml.org/sax/features/external-parameter-entities", false);
        C3P0ConfigXmlUtils.attemptSetFeature(documentBuilderFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
    }

    public static C3P0Config extractXmlConfigFromInputStream(InputStream inputStream, boolean bl) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        if (!bl) {
            C3P0ConfigXmlUtils.cautionDocumentBuilderFactory(documentBuilderFactory);
        }
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        return C3P0ConfigXmlUtils.extractConfigFromXmlDoc(document);
    }

    public static C3P0Config extractConfigFromXmlDoc(Document document) throws Exception {
        Element element = document.getDocumentElement();
        if (element.getTagName().equals("c3p0-config")) {
            HashMap<String, NamedScope> hashMap = new HashMap<String, NamedScope>();
            Element element2 = DomParseUtils.uniqueChild((Element)element, (String)"default-config");
            NamedScope namedScope = element2 != null ? C3P0ConfigXmlUtils.extractNamedScopeFromLevel(element2) : new NamedScope();
            NodeList nodeList = DomParseUtils.immediateChildElementsByTagName((Element)element, (String)"named-config");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element3 = (Element)nodeList.item(i);
                String string = element3.getAttribute("name");
                if (string != null && string.length() > 0) {
                    NamedScope namedScope2 = C3P0ConfigXmlUtils.extractNamedScopeFromLevel(element3);
                    hashMap.put(string, namedScope2);
                    continue;
                }
                logger.warning("Configuration XML contained named-config element without name attribute: " + element3);
            }
            return new C3P0Config(namedScope, hashMap);
        }
        throw new Exception("Root element of c3p0 config xml should be 'c3p0-config', not '" + element.getTagName() + "'.");
    }

    private static NamedScope extractNamedScopeFromLevel(Element element) {
        HashMap hashMap = C3P0ConfigXmlUtils.extractPropertiesFromLevel(element);
        HashMap<String, HashMap> hashMap2 = new HashMap<String, HashMap>();
        NodeList nodeList = DomParseUtils.immediateChildElementsByTagName((Element)element, (String)"user-overrides");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("user");
            if (string != null && string.length() > 0) {
                HashMap hashMap3 = C3P0ConfigXmlUtils.extractPropertiesFromLevel(element2);
                hashMap2.put(string, hashMap3);
                continue;
            }
            logger.warning("Configuration XML contained user-overrides element without user attribute: " + LINESEP + element2);
        }
        HashMap hashMap4 = C3P0ConfigXmlUtils.extractExtensionsFromLevel(element);
        return new NamedScope(hashMap, hashMap2, hashMap4);
    }

    private static HashMap extractExtensionsFromLevel(Element element) {
        HashMap hashMap = new HashMap();
        NodeList nodeList = DomParseUtils.immediateChildElementsByTagName((Element)element, (String)"extensions");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            hashMap.putAll(C3P0ConfigXmlUtils.extractPropertiesFromLevel(element2));
        }
        return hashMap;
    }

    private static HashMap extractPropertiesFromLevel(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            NodeList nodeList = DomParseUtils.immediateChildElementsByTagName((Element)element, (String)"property");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = element2.getAttribute("name");
                if (string != null && string.length() > 0) {
                    String string2 = DomParseUtils.allTextFromElement((Element)element2, (boolean)true);
                    hashMap.put(string, string2);
                    continue;
                }
                logger.warning("Configuration XML contained property element without name attribute: " + LINESEP + element2);
            }
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, "An exception occurred while reading config XML. Some configuration information has probably been ignored.", (Throwable)exception);
        }
        return hashMap;
    }

    private C3P0ConfigXmlUtils() {
    }

    static {
        String string;
        logger = MLog.getLogger(C3P0ConfigXmlUtils.class);
        MISSPELL_PFXS = new String[]{"/c3p0", "/c3pO", "/c3po", "/C3P0", "/C3PO"};
        MISSPELL_LINES = new char[]{'-', '_'};
        MISSPELL_CONFIG = new String[]{"config", "CONFIG"};
        MISSPELL_XML = new String[]{"xml", "XML"};
        try {
            string = System.getProperty("line.separator", "\r\n");
        }
        catch (Exception exception) {
            string = "\r\n";
        }
        LINESEP = string;
    }
}

