/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.mastercard.developer.encryption.EncryptionConfig;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryption;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.encryption.FieldLevelEncryptionParams;
import com.mastercard.developer.interceptors.OpenFeignEncoderExecutor;
import com.mastercard.developer.utils.FeignUtils;
import feign.RequestTemplate;
import feign.codec.Encoder;

public class OpenFeignFieldLevelEncryptionEncoder
extends OpenFeignEncoderExecutor {
    private final FieldLevelEncryptionConfig config;

    public OpenFeignFieldLevelEncryptionEncoder(EncryptionConfig config, Encoder delegate) {
        super(delegate);
        this.config = (FieldLevelEncryptionConfig)config;
    }

    @Override
    protected String encryptPayload(RequestTemplate requestTemplate, String requestPayload) throws EncryptionException {
        if (this.config.useHttpHeaders()) {
            FieldLevelEncryptionParams params = FieldLevelEncryptionParams.generate(this.config);
            FeignUtils.updateHeader(requestTemplate, this.config.getIvHeaderName(), params.getIvValue());
            FeignUtils.updateHeader(requestTemplate, this.config.getEncryptedKeyHeaderName(), params.getEncryptedKeyValue());
            FeignUtils.updateHeader(requestTemplate, this.config.getEncryptionCertificateFingerprintHeaderName(), this.config.getEncryptionCertificateFingerprint());
            FeignUtils.updateHeader(requestTemplate, this.config.getEncryptionKeyFingerprintHeaderName(), this.config.getEncryptionKeyFingerprint());
            FeignUtils.updateHeader(requestTemplate, this.config.getOaepPaddingDigestAlgorithmHeaderName(), params.getOaepPaddingDigestAlgorithmValue());
            return FieldLevelEncryption.encryptPayload(requestPayload, this.config, params);
        }
        return FieldLevelEncryption.encryptPayload(requestPayload, this.config);
    }
}

