/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.mastercard.developer.encryption.EncryptionConfig;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.interceptors.OpenFeignFieldLevelEncryptionEncoder;
import com.mastercard.developer.interceptors.OpenFeignJweEncoder;
import com.mastercard.developer.utils.FeignUtils;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

public abstract class OpenFeignEncoderExecutor
implements Encoder {
    private final Encoder delegate;

    public static OpenFeignEncoderExecutor from(EncryptionConfig config, Encoder delegate) {
        return config.getScheme().equals((Object)EncryptionConfig.Scheme.JWE) ? new OpenFeignJweEncoder(config, delegate) : new OpenFeignFieldLevelEncryptionEncoder(config, delegate);
    }

    OpenFeignEncoderExecutor(Encoder delegate) {
        this.delegate = delegate;
    }

    protected abstract String encryptPayload(RequestTemplate var1, String var2) throws EncryptionException;

    public void encode(Object object, Type type, RequestTemplate requestTemplate) {
        this.delegate.encode(object, type, requestTemplate);
        try {
            byte[] bodyBytes = requestTemplate.body();
            if (null == bodyBytes || bodyBytes.length <= 0) {
                return;
            }
            String payload = new String(bodyBytes, StandardCharsets.UTF_8);
            String encryptedPayload = this.encryptPayload(requestTemplate, payload);
            requestTemplate.body(encryptedPayload);
            FeignUtils.updateHeader(requestTemplate, "Content-Length", String.valueOf(encryptedPayload.length()));
        }
        catch (EncryptionException e) {
            throw new EncodeException("Failed to intercept and encrypt request!", (Throwable)e);
        }
    }
}

