/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.interceptors;

import com.google.api.client.http.HttpHeaders;
import com.mastercard.developer.encryption.EncryptionConfig;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.FieldLevelEncryption;
import com.mastercard.developer.encryption.FieldLevelEncryptionConfig;
import com.mastercard.developer.encryption.FieldLevelEncryptionParams;
import com.mastercard.developer.interceptors.HttpExecuteEncryptionInterceptor;

public class HttpExecuteFieldLevelEncryptionInterceptor
extends HttpExecuteEncryptionInterceptor {
    private final FieldLevelEncryptionConfig config;

    public HttpExecuteFieldLevelEncryptionInterceptor(EncryptionConfig config) {
        this.config = (FieldLevelEncryptionConfig)config;
    }

    @Override
    protected String encryptPayload(HttpHeaders headers, String requestPayload) throws EncryptionException {
        if (this.config.useHttpHeaders()) {
            FieldLevelEncryptionParams params = FieldLevelEncryptionParams.generate(this.config);
            HttpExecuteFieldLevelEncryptionInterceptor.updateHeader(headers, this.config.getIvHeaderName(), params.getIvValue());
            HttpExecuteFieldLevelEncryptionInterceptor.updateHeader(headers, this.config.getEncryptedKeyHeaderName(), params.getEncryptedKeyValue());
            HttpExecuteFieldLevelEncryptionInterceptor.updateHeader(headers, this.config.getEncryptionCertificateFingerprintHeaderName(), this.config.getEncryptionCertificateFingerprint());
            HttpExecuteFieldLevelEncryptionInterceptor.updateHeader(headers, this.config.getEncryptionKeyFingerprintHeaderName(), this.config.getEncryptionKeyFingerprint());
            HttpExecuteFieldLevelEncryptionInterceptor.updateHeader(headers, this.config.getOaepPaddingDigestAlgorithmHeaderName(), params.getOaepPaddingDigestAlgorithmValue());
            return FieldLevelEncryption.encryptPayload(requestPayload, this.config, params);
        }
        return FieldLevelEncryption.encryptPayload(requestPayload, this.config);
    }

    @Override
    protected String decryptPayload(HttpHeaders headers, String responsePayload) throws EncryptionException {
        if (this.config.useHttpHeaders()) {
            String ivValue = headers.getFirstHeaderStringValue(this.config.getIvHeaderName());
            String oaepPaddingDigestAlgorithmValue = headers.getFirstHeaderStringValue(this.config.getOaepPaddingDigestAlgorithmHeaderName());
            String encryptedKeyValue = headers.getFirstHeaderStringValue(this.config.getEncryptedKeyHeaderName());
            HttpExecuteFieldLevelEncryptionInterceptor.removeHeader(headers, this.config.getIvHeaderName());
            HttpExecuteFieldLevelEncryptionInterceptor.removeHeader(headers, this.config.getEncryptedKeyHeaderName());
            HttpExecuteFieldLevelEncryptionInterceptor.removeHeader(headers, this.config.getOaepPaddingDigestAlgorithmHeaderName());
            HttpExecuteFieldLevelEncryptionInterceptor.removeHeader(headers, this.config.getEncryptionCertificateFingerprintHeaderName());
            HttpExecuteFieldLevelEncryptionInterceptor.removeHeader(headers, this.config.getEncryptionKeyFingerprintHeaderName());
            FieldLevelEncryptionParams params = new FieldLevelEncryptionParams(ivValue, encryptedKeyValue, oaepPaddingDigestAlgorithmValue, this.config);
            return FieldLevelEncryption.decryptPayload(responsePayload, this.config, params);
        }
        return FieldLevelEncryption.decryptPayload(responsePayload, this.config);
    }
}

