/*
 * Decompiled with CFR 0.152.
 */
package com.mastercard.developer.encryption;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.mastercard.developer.encryption.EncryptionException;
import com.mastercard.developer.encryption.JsonParser;
import com.mastercard.developer.encryption.JweConfig;
import com.mastercard.developer.encryption.jwe.JweHeader;
import com.mastercard.developer.encryption.jwe.JweObject;
import com.mastercard.developer.utils.EncryptionUtils;
import java.security.GeneralSecurityException;
import java.util.Map;

public class JweEncryption {
    private static final String ALGORITHM = "RSA-OAEP-256";
    private static final String ENCRYPTION = "A256GCM";
    private static final String CONTENT_TYPE = "application/json";

    private JweEncryption() {
    }

    public static String encryptPayload(String payload, JweConfig config) throws EncryptionException {
        try {
            DocumentContext payloadContext = JsonPath.parse((String)payload, (Configuration)JsonParser.jsonPathConfig);
            for (Map.Entry<String, String> entry : config.getEncryptionPaths().entrySet()) {
                String jsonPathIn = entry.getKey();
                String jsonPathOut = entry.getValue();
                if (!jsonPathIn.contains("[*]")) {
                    payloadContext = JweEncryption.encryptPayloadPath(payloadContext, jsonPathIn, jsonPathOut, config);
                    continue;
                }
                String getFieldLength = jsonPathIn.split("\\[.*?\\]")[0].concat(".length()");
                Integer length = (Integer)JsonPath.read((String)payload, (String)getFieldLength, (Predicate[])new Predicate[0]);
                Integer i = 0;
                while (i < length) {
                    String newJsonPathIn = jsonPathIn.replace("*", i.toString());
                    String newJsonPathOut = jsonPathOut.replace("*", i.toString());
                    payloadContext = JweEncryption.encryptPayloadPath(payloadContext, newJsonPathIn, newJsonPathOut, config);
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            }
            return payloadContext.jsonString();
        }
        catch (Exception e) {
            throw new EncryptionException("Payload encryption failed!", e);
        }
    }

    public static String decryptPayload(String payload, JweConfig config) throws EncryptionException {
        try {
            DocumentContext payloadContext = JsonPath.parse((String)payload, (Configuration)JsonParser.jsonPathConfig);
            for (Map.Entry<String, String> entry : config.getDecryptionPaths().entrySet()) {
                String jsonPathIn = entry.getKey();
                String jsonPathOut = entry.getValue();
                if (!jsonPathIn.contains("[*]")) {
                    payloadContext = JweEncryption.decryptPayloadPath(payloadContext, jsonPathIn, jsonPathOut, config);
                    continue;
                }
                String getFieldLength = jsonPathIn.split("\\[.*?\\]")[0].concat(".length()");
                Integer length = (Integer)JsonPath.read((String)payload, (String)getFieldLength, (Predicate[])new Predicate[0]);
                Integer i = 0;
                while (i < length) {
                    String newJsonPathIn = jsonPathIn.replace("*", i.toString());
                    String newJsonPathOut = jsonPathOut.replace("*", i.toString());
                    payloadContext = JweEncryption.decryptPayloadPath(payloadContext, newJsonPathIn, newJsonPathOut, config);
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            }
            return payloadContext.jsonString();
        }
        catch (Exception e) {
            throw new EncryptionException("Payload decryption failed!", e);
        }
    }

    private static DocumentContext encryptPayloadPath(DocumentContext payloadContext, String jsonPathIn, String jsonPathOut, JweConfig config) throws EncryptionException, GeneralSecurityException {
        Object inJsonElement = JsonParser.readJsonElement(payloadContext, jsonPathIn);
        if (inJsonElement == null) {
            return payloadContext;
        }
        String inJsonString = EncryptionUtils.sanitizeJson(JsonParser.jsonEngine.toJsonString(inJsonElement));
        JweHeader myHeader = new JweHeader(ALGORITHM, ENCRYPTION, config.encryptionKeyFingerprint, CONTENT_TYPE);
        String payload = JweObject.encrypt(config, inJsonString, myHeader);
        if (!"$".equals(jsonPathIn)) {
            payloadContext.delete(jsonPathIn, new Predicate[0]);
        } else {
            payloadContext = JsonPath.parse((String)"{}", (Configuration)JsonParser.jsonPathConfig);
        }
        JsonParser.checkOrCreateOutObject(payloadContext, jsonPathOut);
        payloadContext.put(jsonPathOut, config.encryptedValueFieldName, (Object)payload, new Predicate[0]);
        return payloadContext;
    }

    private static DocumentContext decryptPayloadPath(DocumentContext payloadContext, String jsonPathIn, String jsonPathOut, JweConfig config) throws EncryptionException, GeneralSecurityException {
        Object inJsonObject = JweEncryption.readJsonObject(payloadContext, jsonPathIn);
        if (inJsonObject == null) {
            return payloadContext;
        }
        Object encryptedValueJsonElement = JweEncryption.readAndDeleteJsonKey(payloadContext, inJsonObject, config.encryptedValueFieldName);
        if (JsonParser.jsonEngine.isNullOrEmptyJson(encryptedValueJsonElement)) {
            return payloadContext;
        }
        String encryptedValue = JsonParser.jsonEngine.toJsonString(encryptedValueJsonElement).replace("\"", "");
        JweObject jweObject = JweObject.parse(encryptedValue, JsonParser.jsonEngine);
        String decryptedValue = jweObject.decrypt(config);
        if ("$".equals(jsonPathOut)) {
            payloadContext = JsonPath.parse((String)decryptedValue, (Configuration)JsonParser.jsonPathConfig);
        } else {
            JsonParser.checkOrCreateOutObject(payloadContext, jsonPathOut);
            JsonParser.addDecryptedDataToPayload(payloadContext, decryptedValue, jsonPathOut);
        }
        payloadContext.delete(jsonPathIn, new Predicate[0]);
        return payloadContext;
    }

    private static Object readAndDeleteJsonKey(DocumentContext context, Object object, String key) {
        context.delete(key, new Predicate[0]);
        return object;
    }

    private static Object readJsonObject(DocumentContext context, String jsonPathString) {
        return JsonParser.readJsonElement(context, jsonPathString);
    }
}

