/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.tsp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spongycastle.asn1.ASN1Boolean;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1GeneralizedTime;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.DERNull;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.ess.ESSCertID;
import org.spongycastle.asn1.ess.SigningCertificate;
import org.spongycastle.asn1.oiw.OIWObjectIdentifiers;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.tsp.Accuracy;
import org.spongycastle.asn1.tsp.MessageImprint;
import org.spongycastle.asn1.tsp.TSTInfo;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.GeneralName;
import org.spongycastle.cert.jcajce.JcaX509CRLHolder;
import org.spongycastle.cert.jcajce.JcaX509CertificateHolder;
import org.spongycastle.cms.CMSAttributeTableGenerationException;
import org.spongycastle.cms.CMSAttributeTableGenerator;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSProcessableByteArray;
import org.spongycastle.cms.CMSSignedData;
import org.spongycastle.cms.CMSSignedDataGenerator;
import org.spongycastle.cms.CMSSignedGenerator;
import org.spongycastle.cms.DefaultSignedAttributeTableGenerator;
import org.spongycastle.cms.SignerInfoGenerator;
import org.spongycastle.cms.SimpleAttributeTableGenerator;
import org.spongycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.spongycastle.jce.interfaces.GOST3410PrivateKey;
import org.spongycastle.operator.DigestCalculator;
import org.spongycastle.operator.OperatorCreationException;
import org.spongycastle.operator.jcajce.JcaContentSignerBuilder;
import org.spongycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.spongycastle.tsp.TSPException;
import org.spongycastle.tsp.TSPUtil;
import org.spongycastle.tsp.TimeStampRequest;
import org.spongycastle.tsp.TimeStampToken;
import org.spongycastle.util.CollectionStore;
import org.spongycastle.util.Store;

public class TimeStampTokenGenerator {
    int accuracySeconds = -1;
    int accuracyMillis = -1;
    int accuracyMicros = -1;
    boolean ordering = false;
    GeneralName tsa = null;
    private ASN1ObjectIdentifier tsaPolicyOID;
    PrivateKey key;
    X509Certificate cert;
    String digestOID;
    AttributeTable signedAttr;
    AttributeTable unsignedAttr;
    private List certs = new ArrayList();
    private List crls = new ArrayList();
    private List attrCerts = new ArrayList();
    private SignerInfoGenerator signerInfoGen;

    public TimeStampTokenGenerator(DigestCalculator sha1DigestCalculator, final SignerInfoGenerator signerInfoGen, ASN1ObjectIdentifier tsaPolicy) throws IllegalArgumentException, TSPException {
        this.signerInfoGen = signerInfoGen;
        this.tsaPolicyOID = tsaPolicy;
        if (!sha1DigestCalculator.getAlgorithmIdentifier().getAlgorithm().equals((Object)OIWObjectIdentifiers.idSHA1)) {
            throw new IllegalArgumentException("Digest calculator must be for SHA-1");
        }
        if (!signerInfoGen.hasAssociatedCertificate()) {
            throw new IllegalArgumentException("SignerInfoGenerator must have an associated certificate");
        }
        TSPUtil.validateCertificate(signerInfoGen.getAssociatedCertificate());
        try {
            OutputStream dOut = sha1DigestCalculator.getOutputStream();
            dOut.write(signerInfoGen.getAssociatedCertificate().getEncoded());
            dOut.close();
            final ESSCertID essCertid = new ESSCertID(sha1DigestCalculator.getDigest());
            this.signerInfoGen = new SignerInfoGenerator(signerInfoGen, new CMSAttributeTableGenerator(){

                public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
                    AttributeTable table = signerInfoGen.getSignedAttributeTableGenerator().getAttributes(parameters);
                    return table.add(PKCSObjectIdentifiers.id_aa_signingCertificate, (ASN1Encodable)new SigningCertificate(essCertid));
                }
            }, signerInfoGen.getUnsignedAttributeTableGenerator());
        }
        catch (IOException e) {
            throw new TSPException("Exception processing certificate.", e);
        }
    }

    public TimeStampTokenGenerator(SignerInfoGenerator signerInfoGen, ASN1ObjectIdentifier tsaPolicy) throws IllegalArgumentException, TSPException {
        this(new DigestCalculator(){
            private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)DERNull.INSTANCE);
            }

            public OutputStream getOutputStream() {
                return this.bOut;
            }

            public byte[] getDigest() {
                try {
                    return MessageDigest.getInstance("SHA-1").digest(this.bOut.toByteArray());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException("cannot find sha-1: " + e.getMessage());
                }
            }
        }, signerInfoGen, tsaPolicy);
    }

    public TimeStampTokenGenerator(PrivateKey key, X509Certificate cert, String digestOID, String tsaPolicyOID) throws IllegalArgumentException, TSPException {
        this(key, cert, digestOID, tsaPolicyOID, null, null);
    }

    public TimeStampTokenGenerator(PrivateKey key, X509Certificate cert, ASN1ObjectIdentifier digestOID, String tsaPolicyOID) throws IllegalArgumentException, TSPException {
        this(key, cert, digestOID.getId(), tsaPolicyOID, null, null);
    }

    public TimeStampTokenGenerator(PrivateKey key, X509Certificate cert, String digestOID, String tsaPolicyOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException, TSPException {
        this.key = key;
        this.cert = cert;
        this.digestOID = digestOID;
        this.tsaPolicyOID = new ASN1ObjectIdentifier(tsaPolicyOID);
        this.unsignedAttr = unsignedAttr;
        Hashtable<ASN1ObjectIdentifier, Attribute> signedAttrs = null;
        signedAttrs = signedAttr != null ? signedAttr.toHashtable() : new Hashtable<ASN1ObjectIdentifier, Attribute>();
        TSPUtil.validateCertificate(cert);
        try {
            ESSCertID essCertid = new ESSCertID(MessageDigest.getInstance("SHA-1").digest(cert.getEncoded()));
            signedAttrs.put(PKCSObjectIdentifiers.id_aa_signingCertificate, new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificate, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificate(essCertid))));
        }
        catch (NoSuchAlgorithmException e) {
            throw new TSPException("Can't find a SHA-1 implementation.", e);
        }
        catch (CertificateEncodingException e) {
            throw new TSPException("Exception processing certificate.", e);
        }
        this.signedAttr = new AttributeTable(signedAttrs);
    }

    public void setCertificatesAndCRLs(CertStore certificates) throws CertStoreException, TSPException {
        Collection<Object> c1 = certificates.getCertificates(null);
        Iterator<Object> it = c1.iterator();
        while (it.hasNext()) {
            try {
                this.certs.add(new JcaX509CertificateHolder((X509Certificate)it.next()));
            }
            catch (CertificateEncodingException e) {
                throw new TSPException("cannot encode certificate: " + e.getMessage(), e);
            }
        }
        c1 = certificates.getCRLs(null);
        it = c1.iterator();
        while (it.hasNext()) {
            try {
                this.crls.add(new JcaX509CRLHolder((X509CRL)it.next()));
            }
            catch (CRLException e) {
                throw new TSPException("cannot encode CRL: " + e.getMessage(), e);
            }
        }
    }

    public void addCertificates(Store certStore) {
        this.certs.addAll(certStore.getMatches(null));
    }

    public void addCRLs(Store crlStore) {
        this.crls.addAll(crlStore.getMatches(null));
    }

    public void addAttributeCertificates(Store attrStore) {
        this.attrCerts.addAll(attrStore.getMatches(null));
    }

    public void setAccuracySeconds(int accuracySeconds) {
        this.accuracySeconds = accuracySeconds;
    }

    public void setAccuracyMillis(int accuracyMillis) {
        this.accuracyMillis = accuracyMillis;
    }

    public void setAccuracyMicros(int accuracyMicros) {
        this.accuracyMicros = accuracyMicros;
    }

    public void setOrdering(boolean ordering) {
        this.ordering = ordering;
    }

    public void setTSA(GeneralName tsa) {
        this.tsa = tsa;
    }

    public TimeStampToken generate(TimeStampRequest request, BigInteger serialNumber, Date genTime, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, TSPException {
        if (this.signerInfoGen == null) {
            try {
                JcaSignerInfoGeneratorBuilder sigBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(provider).build());
                sigBuilder.setSignedAttributeGenerator(new DefaultSignedAttributeTableGenerator(this.signedAttr));
                if (this.unsignedAttr != null) {
                    sigBuilder.setUnsignedAttributeGenerator(new SimpleAttributeTableGenerator(this.unsignedAttr));
                }
                this.signerInfoGen = sigBuilder.build(new JcaContentSignerBuilder(this.getSigAlgorithm(this.key, this.digestOID)).setProvider(provider).build(this.key), this.cert);
            }
            catch (OperatorCreationException e) {
                throw new TSPException("Error generating signing operator", e);
            }
            catch (CertificateEncodingException e) {
                throw new TSPException("Error encoding certificate", e);
            }
        }
        return this.generate(request, serialNumber, genTime);
    }

    public TimeStampToken generate(TimeStampRequest request, BigInteger serialNumber, Date genTime) throws TSPException {
        if (this.signerInfoGen == null) {
            throw new IllegalStateException("can only use this method with SignerInfoGenerator constructor");
        }
        ASN1ObjectIdentifier digestAlgOID = request.getMessageImprintAlgOID();
        AlgorithmIdentifier algID = new AlgorithmIdentifier(digestAlgOID, (ASN1Encodable)new DERNull());
        MessageImprint messageImprint = new MessageImprint(algID, request.getMessageImprintDigest());
        Accuracy accuracy = null;
        if (this.accuracySeconds > 0 || this.accuracyMillis > 0 || this.accuracyMicros > 0) {
            ASN1Integer seconds = null;
            if (this.accuracySeconds > 0) {
                seconds = new ASN1Integer(this.accuracySeconds);
            }
            ASN1Integer millis = null;
            if (this.accuracyMillis > 0) {
                millis = new ASN1Integer(this.accuracyMillis);
            }
            ASN1Integer micros = null;
            if (this.accuracyMicros > 0) {
                micros = new ASN1Integer(this.accuracyMicros);
            }
            accuracy = new Accuracy(seconds, millis, micros);
        }
        ASN1Boolean derOrdering = null;
        if (this.ordering) {
            derOrdering = new ASN1Boolean(this.ordering);
        }
        ASN1Integer nonce = null;
        if (request.getNonce() != null) {
            nonce = new ASN1Integer(request.getNonce());
        }
        ASN1ObjectIdentifier tsaPolicy = this.tsaPolicyOID;
        if (request.getReqPolicy() != null) {
            tsaPolicy = request.getReqPolicy();
        }
        TSTInfo tstInfo = new TSTInfo(tsaPolicy, messageImprint, new ASN1Integer(serialNumber), new ASN1GeneralizedTime(genTime), accuracy, derOrdering, nonce, this.tsa, request.getExtensions());
        try {
            CMSSignedDataGenerator signedDataGenerator = new CMSSignedDataGenerator();
            if (request.getCertReq()) {
                signedDataGenerator.addCertificates((Store)new CollectionStore((Collection)this.certs));
                signedDataGenerator.addCRLs((Store)new CollectionStore((Collection)this.crls));
                signedDataGenerator.addAttributeCertificates((Store)new CollectionStore((Collection)this.attrCerts));
            } else {
                signedDataGenerator.addCRLs((Store)new CollectionStore((Collection)this.crls));
            }
            signedDataGenerator.addSignerInfoGenerator(this.signerInfoGen);
            byte[] derEncodedTSTInfo = tstInfo.getEncoded("DER");
            CMSSignedData signedData = signedDataGenerator.generate(new CMSProcessableByteArray(PKCSObjectIdentifiers.id_ct_TSTInfo, derEncodedTSTInfo), true);
            return new TimeStampToken(signedData);
        }
        catch (CMSException cmsEx) {
            throw new TSPException("Error generating time-stamp token", cmsEx);
        }
        catch (IOException e) {
            throw new TSPException("Exception encoding info", e);
        }
    }

    private String getSigAlgorithm(PrivateKey key, String digestOID) {
        String enc = null;
        if (key instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(key.getAlgorithm())) {
            enc = "RSA";
        } else if (key instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(key.getAlgorithm())) {
            enc = "DSA";
        } else if ("ECDSA".equalsIgnoreCase(key.getAlgorithm()) || "EC".equalsIgnoreCase(key.getAlgorithm())) {
            enc = "ECDSA";
        } else if (key instanceof GOST3410PrivateKey || "GOST3410".equalsIgnoreCase(key.getAlgorithm())) {
            enc = "GOST3410";
        } else if ("ECGOST3410".equalsIgnoreCase(key.getAlgorithm())) {
            enc = CMSSignedGenerator.ENCRYPTION_ECGOST3410;
        }
        return TSPUtil.getDigestAlgName(digestOID) + "with" + enc;
    }
}

