/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.DERObjectIdentifier;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.cms.CMSAttributes;
import org.spongycastle.asn1.cms.IssuerAndSerialNumber;
import org.spongycastle.asn1.cms.SignerIdentifier;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.cms.Time;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.DigestInfo;
import org.spongycastle.cert.X509CertificateHolder;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSProcessable;
import org.spongycastle.cms.CMSProcessableByteArray;
import org.spongycastle.cms.CMSSignedHelper;
import org.spongycastle.cms.CMSSignerDigestMismatchException;
import org.spongycastle.cms.CMSUtils;
import org.spongycastle.cms.CMSVerifierCertificateNotValidException;
import org.spongycastle.cms.SignerId;
import org.spongycastle.cms.SignerInformationStore;
import org.spongycastle.cms.SignerInformationVerifier;
import org.spongycastle.cms.jcajce.JcaSignerInfoVerifierBuilder;
import org.spongycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.spongycastle.operator.ContentVerifier;
import org.spongycastle.operator.DigestCalculator;
import org.spongycastle.operator.OperatorCreationException;
import org.spongycastle.operator.RawContentVerifier;
import org.spongycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.spongycastle.util.Arrays;

public class SignerInformation {
    private SignerId sid;
    private SignerInfo info;
    private AlgorithmIdentifier digestAlgorithm;
    private AlgorithmIdentifier encryptionAlgorithm;
    private final ASN1Set signedAttributeSet;
    private final ASN1Set unsignedAttributeSet;
    private CMSProcessable content;
    private byte[] signature;
    private ASN1ObjectIdentifier contentType;
    private byte[] resultDigest;
    private AttributeTable signedAttributeValues;
    private AttributeTable unsignedAttributeValues;
    private boolean isCounterSignature;

    SignerInformation(SignerInfo info, ASN1ObjectIdentifier contentType, CMSProcessable content, byte[] resultDigest) {
        this.info = info;
        this.contentType = contentType;
        this.isCounterSignature = contentType == null;
        SignerIdentifier s = info.getSID();
        if (s.isTagged()) {
            ASN1OctetString octs = ASN1OctetString.getInstance((Object)s.getId());
            this.sid = new SignerId(octs.getOctets());
        } else {
            IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance((Object)s.getId());
            this.sid = new SignerId(iAnds.getName(), iAnds.getSerialNumber().getValue());
        }
        this.digestAlgorithm = info.getDigestAlgorithm();
        this.signedAttributeSet = info.getAuthenticatedAttributes();
        this.unsignedAttributeSet = info.getUnauthenticatedAttributes();
        this.encryptionAlgorithm = info.getDigestEncryptionAlgorithm();
        this.signature = info.getEncryptedDigest().getOctets();
        this.content = content;
        this.resultDigest = resultDigest;
    }

    public boolean isCounterSignature() {
        return this.isCounterSignature;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    private byte[] encodeObj(ASN1Encodable obj) throws IOException {
        if (obj != null) {
            return obj.toASN1Primitive().getEncoded();
        }
        return null;
    }

    public SignerId getSID() {
        return this.sid;
    }

    public int getVersion() {
        return this.info.getVersion().getValue().intValue();
    }

    public AlgorithmIdentifier getDigestAlgorithmID() {
        return this.digestAlgorithm;
    }

    public String getDigestAlgOID() {
        return this.digestAlgorithm.getObjectId().getId();
    }

    public byte[] getDigestAlgParams() {
        try {
            return this.encodeObj(this.digestAlgorithm.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting digest parameters " + e);
        }
    }

    public byte[] getContentDigest() {
        if (this.resultDigest == null) {
            throw new IllegalStateException("method can only be called after verify.");
        }
        return (byte[])this.resultDigest.clone();
    }

    public String getEncryptionAlgOID() {
        return this.encryptionAlgorithm.getObjectId().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this.encryptionAlgorithm.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AttributeTable getSignedAttributes() {
        if (this.signedAttributeSet != null && this.signedAttributeValues == null) {
            this.signedAttributeValues = new AttributeTable(this.signedAttributeSet);
        }
        return this.signedAttributeValues;
    }

    public AttributeTable getUnsignedAttributes() {
        if (this.unsignedAttributeSet != null && this.unsignedAttributeValues == null) {
            this.unsignedAttributeValues = new AttributeTable(this.unsignedAttributeSet);
        }
        return this.unsignedAttributeValues;
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public SignerInformationStore getCounterSignatures() {
        AttributeTable unsignedAttributeTable = this.getUnsignedAttributes();
        if (unsignedAttributeTable == null) {
            return new SignerInformationStore(new ArrayList(0));
        }
        ArrayList<SignerInformation> counterSignatures = new ArrayList<SignerInformation>();
        ASN1EncodableVector allCSAttrs = unsignedAttributeTable.getAll(CMSAttributes.counterSignature);
        for (int i = 0; i < allCSAttrs.size(); ++i) {
            Attribute counterSignatureAttribute = (Attribute)allCSAttrs.get(i);
            ASN1Set values = counterSignatureAttribute.getAttrValues();
            if (values.size() < 1) {
                // empty if block
            }
            Enumeration en = values.getObjects();
            while (en.hasMoreElements()) {
                SignerInfo si = SignerInfo.getInstance(en.nextElement());
                counterSignatures.add(new SignerInformation(si, null, new CMSProcessableByteArray(this.getSignature()), null));
            }
        }
        return new SignerInformationStore(counterSignatures);
    }

    public byte[] getEncodedSignedAttributes() throws IOException {
        if (this.signedAttributeSet != null) {
            return this.signedAttributeSet.getEncoded();
        }
        return null;
    }

    private boolean doVerify(PublicKey key, Provider sigProvider) throws CMSException, NoSuchAlgorithmException {
        try {
            SignerInformationVerifier verifier = sigProvider != null ? (!sigProvider.getName().equalsIgnoreCase("SC") ? new JcaSignerInfoVerifierBuilder(new JcaDigestCalculatorProviderBuilder().build()).setProvider(sigProvider).build(key) : new JcaSimpleSignerInfoVerifierBuilder().setProvider(sigProvider).build(key)) : new JcaSimpleSignerInfoVerifierBuilder().build(key);
            return this.doVerify(verifier);
        }
        catch (OperatorCreationException e) {
            throw new CMSException("unable to create verifier: " + e.getMessage(), e);
        }
    }

    private boolean doVerify(SignerInformationVerifier verifier) throws CMSException {
        AttributeTable signedAttrTable;
        ASN1Primitive validMessageDigest;
        String encName = CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.getEncryptionAlgOID());
        try {
            if (this.resultDigest == null) {
                DigestCalculator calc = verifier.getDigestCalculator(this.getDigestAlgorithmID());
                if (this.content != null) {
                    OutputStream digOut = calc.getOutputStream();
                    this.content.write(digOut);
                    digOut.close();
                } else if (this.signedAttributeSet == null) {
                    throw new CMSException("data not encapsulated in signature - use detached constructor.");
                }
                this.resultDigest = calc.getDigest();
            }
        }
        catch (IOException e) {
            throw new CMSException("can't process mime object to create signature.", e);
        }
        catch (OperatorCreationException e) {
            throw new CMSException("can't create digest calculator: " + e.getMessage(), e);
        }
        ASN1Primitive validContentType = this.getSingleValuedSignedAttribute(CMSAttributes.contentType, "content-type");
        if (validContentType == null) {
            if (!this.isCounterSignature && this.signedAttributeSet != null) {
                throw new CMSException("The content-type attribute type MUST be present whenever signed attributes are present in signed-data");
            }
        } else {
            if (this.isCounterSignature) {
                throw new CMSException("[For counter signatures,] the signedAttributes field MUST NOT contain a content-type attribute");
            }
            if (!(validContentType instanceof DERObjectIdentifier)) {
                throw new CMSException("content-type attribute value not of ASN.1 type 'OBJECT IDENTIFIER'");
            }
            DERObjectIdentifier signedContentType = (DERObjectIdentifier)validContentType;
            if (!signedContentType.equals((Object)this.contentType)) {
                throw new CMSException("content-type attribute value does not match eContentType");
            }
        }
        if ((validMessageDigest = this.getSingleValuedSignedAttribute(CMSAttributes.messageDigest, "message-digest")) == null) {
            if (this.signedAttributeSet != null) {
                throw new CMSException("the message-digest signed attribute type MUST be present when there are any signed attributes present");
            }
        } else {
            if (!(validMessageDigest instanceof ASN1OctetString)) {
                throw new CMSException("message-digest attribute value not of ASN.1 type 'OCTET STRING'");
            }
            ASN1OctetString signedMessageDigest = (ASN1OctetString)validMessageDigest;
            if (!Arrays.constantTimeAreEqual((byte[])this.resultDigest, (byte[])signedMessageDigest.getOctets())) {
                throw new CMSSignerDigestMismatchException("message-digest attribute value does not match calculated value");
            }
        }
        if ((signedAttrTable = this.getSignedAttributes()) != null && signedAttrTable.getAll(CMSAttributes.counterSignature).size() > 0) {
            throw new CMSException("A countersignature attribute MUST NOT be a signed attribute");
        }
        AttributeTable unsignedAttrTable = this.getUnsignedAttributes();
        if (unsignedAttrTable != null) {
            ASN1EncodableVector csAttrs = unsignedAttrTable.getAll(CMSAttributes.counterSignature);
            for (int i = 0; i < csAttrs.size(); ++i) {
                Attribute csAttr = (Attribute)csAttrs.get(i);
                if (csAttr.getAttrValues().size() >= 1) continue;
                throw new CMSException("A countersignature attribute MUST contain at least one AttributeValue");
            }
        }
        try {
            ContentVerifier contentVerifier = verifier.getContentVerifier(this.encryptionAlgorithm, this.info.getDigestAlgorithm());
            OutputStream sigOut = contentVerifier.getOutputStream();
            if (this.signedAttributeSet == null) {
                if (this.resultDigest != null) {
                    if (contentVerifier instanceof RawContentVerifier) {
                        RawContentVerifier rawVerifier = (RawContentVerifier)((Object)contentVerifier);
                        if (encName.equals("RSA")) {
                            DigestInfo digInfo = new DigestInfo(this.digestAlgorithm, this.resultDigest);
                            return rawVerifier.verify(digInfo.getEncoded("DER"), this.getSignature());
                        }
                        return rawVerifier.verify(this.resultDigest, this.getSignature());
                    }
                    throw new CMSException("verifier unable to process raw signature");
                }
                if (this.content != null) {
                    this.content.write(sigOut);
                }
            } else {
                sigOut.write(this.getEncodedSignedAttributes());
            }
            sigOut.close();
            return contentVerifier.verify(this.getSignature());
        }
        catch (IOException e) {
            throw new CMSException("can't process mime object to create signature.", e);
        }
        catch (OperatorCreationException e) {
            throw new CMSException("can't create content verifier: " + e.getMessage(), e);
        }
    }

    public boolean verify(PublicKey key, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.verify(key, CMSUtils.getProvider(sigProvider));
    }

    public boolean verify(PublicKey key, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        this.getSigningTime();
        return this.doVerify(key, sigProvider);
    }

    public boolean verify(X509Certificate cert, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateExpiredException, CertificateNotYetValidException, CMSException {
        return this.verify(cert, CMSUtils.getProvider(sigProvider));
    }

    public boolean verify(X509Certificate cert, Provider sigProvider) throws NoSuchAlgorithmException, CertificateExpiredException, CertificateNotYetValidException, CMSException {
        Time signingTime = this.getSigningTime();
        if (signingTime != null) {
            cert.checkValidity(signingTime.getDate());
        }
        return this.doVerify(cert.getPublicKey(), sigProvider);
    }

    public boolean verify(SignerInformationVerifier verifier) throws CMSException {
        X509CertificateHolder dcv;
        Time signingTime = this.getSigningTime();
        if (verifier.hasAssociatedCertificate() && signingTime != null && !(dcv = verifier.getAssociatedCertificate()).isValidOn(signingTime.getDate())) {
            throw new CMSVerifierCertificateNotValidException("verifier not valid at signingTime");
        }
        return this.doVerify(verifier);
    }

    public SignerInfo toSignerInfo() {
        return this.info;
    }

    public SignerInfo toASN1Structure() {
        return this.info;
    }

    private ASN1Primitive getSingleValuedSignedAttribute(ASN1ObjectIdentifier attrOID, String printableName) throws CMSException {
        AttributeTable unsignedAttrTable = this.getUnsignedAttributes();
        if (unsignedAttrTable != null && unsignedAttrTable.getAll(attrOID).size() > 0) {
            throw new CMSException("The " + printableName + " attribute MUST NOT be an unsigned attribute");
        }
        AttributeTable signedAttrTable = this.getSignedAttributes();
        if (signedAttrTable == null) {
            return null;
        }
        ASN1EncodableVector v = signedAttrTable.getAll(attrOID);
        switch (v.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Attribute t = (Attribute)v.get(0);
                ASN1Set attrValues = t.getAttrValues();
                if (attrValues.size() != 1) {
                    throw new CMSException("A " + printableName + " attribute MUST have a single attribute value");
                }
                return attrValues.getObjectAt(0).toASN1Primitive();
            }
        }
        throw new CMSException("The SignedAttributes in a signerInfo MUST NOT include multiple instances of the " + printableName + " attribute");
    }

    private Time getSigningTime() throws CMSException {
        ASN1Primitive validSigningTime = this.getSingleValuedSignedAttribute(CMSAttributes.signingTime, "signing-time");
        if (validSigningTime == null) {
            return null;
        }
        try {
            return Time.getInstance((Object)validSigningTime);
        }
        catch (IllegalArgumentException e) {
            throw new CMSException("signing-time attribute value not a valid 'Time' structure");
        }
    }

    public static SignerInformation replaceUnsignedAttributes(SignerInformation signerInformation, AttributeTable unsignedAttributes) {
        SignerInfo sInfo = signerInformation.info;
        DERSet unsignedAttr = null;
        if (unsignedAttributes != null) {
            unsignedAttr = new DERSet(unsignedAttributes.toASN1EncodableVector());
        }
        return new SignerInformation(new SignerInfo(sInfo.getSID(), sInfo.getDigestAlgorithm(), sInfo.getAuthenticatedAttributes(), sInfo.getDigestEncryptionAlgorithm(), sInfo.getEncryptedDigest(), (ASN1Set)unsignedAttr), signerInformation.contentType, signerInformation.content, null);
    }

    public static SignerInformation addCounterSigners(SignerInformation signerInformation, SignerInformationStore counterSigners) {
        SignerInfo sInfo = signerInformation.info;
        AttributeTable unsignedAttr = signerInformation.getUnsignedAttributes();
        ASN1EncodableVector v = unsignedAttr != null ? unsignedAttr.toASN1EncodableVector() : new ASN1EncodableVector();
        ASN1EncodableVector sigs = new ASN1EncodableVector();
        Iterator it = counterSigners.getSigners().iterator();
        while (it.hasNext()) {
            sigs.add((ASN1Encodable)((SignerInformation)it.next()).toSignerInfo());
        }
        v.add((ASN1Encodable)new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet(sigs)));
        return new SignerInformation(new SignerInfo(sInfo.getSID(), sInfo.getDigestAlgorithm(), sInfo.getAuthenticatedAttributes(), sInfo.getDigestEncryptionAlgorithm(), sInfo.getEncryptedDigest(), (ASN1Set)new DERSet(v)), signerInformation.contentType, signerInformation.content, null);
    }
}

