/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.BEROctetString;
import org.spongycastle.asn1.BERSet;
import org.spongycastle.asn1.DERObjectIdentifier;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.AuthenticatedData;
import org.spongycastle.asn1.cms.CMSObjectIdentifiers;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.cms.CMSAuthenticatedData;
import org.spongycastle.cms.CMSAuthenticatedGenerator;
import org.spongycastle.cms.CMSEnvelopedHelper;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSProcessable;
import org.spongycastle.cms.CMSTypedData;
import org.spongycastle.cms.CMSUtils;
import org.spongycastle.cms.DefaultAuthenticatedAttributeTableGenerator;
import org.spongycastle.cms.RecipientInfoGenerator;
import org.spongycastle.cms.jcajce.JceCMSMacCalculatorBuilder;
import org.spongycastle.operator.DigestCalculator;
import org.spongycastle.operator.DigestCalculatorProvider;
import org.spongycastle.operator.MacCalculator;
import org.spongycastle.operator.OperatorCreationException;
import org.spongycastle.util.io.TeeOutputStream;

public class CMSAuthenticatedDataGenerator
extends CMSAuthenticatedGenerator {
    public CMSAuthenticatedDataGenerator() {
    }

    public CMSAuthenticatedData generate(CMSTypedData typedData, MacCalculator macCalculator) throws CMSException {
        return this.generate(typedData, macCalculator, null);
    }

    public CMSAuthenticatedData generate(CMSTypedData typedData, MacCalculator macCalculator, final DigestCalculator digestCalculator) throws CMSException {
        AuthenticatedData authData;
        ByteArrayOutputStream bOut;
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        for (RecipientInfoGenerator recipient : this.recipientInfoGenerators) {
            recipientInfos.add((ASN1Encodable)recipient.generate(macCalculator.getKey()));
        }
        if (digestCalculator != null) {
            DEROctetString macResult;
            BEROctetString encContent;
            try {
                bOut = new ByteArrayOutputStream();
                TeeOutputStream out = new TeeOutputStream(digestCalculator.getOutputStream(), (OutputStream)bOut);
                typedData.write((OutputStream)out);
                out.close();
                encContent = new BEROctetString(bOut.toByteArray());
            }
            catch (IOException e) {
                throw new CMSException("unable to perform digest calculation: " + e.getMessage(), e);
            }
            Map parameters = this.getBaseParameters((DERObjectIdentifier)typedData.getContentType(), digestCalculator.getAlgorithmIdentifier(), digestCalculator.getDigest());
            if (this.authGen == null) {
                this.authGen = new DefaultAuthenticatedAttributeTableGenerator();
            }
            DERSet authed = new DERSet(this.authGen.getAttributes(Collections.unmodifiableMap(parameters)).toASN1EncodableVector());
            try {
                OutputStream mOut = macCalculator.getOutputStream();
                mOut.write(authed.getEncoded("DER"));
                mOut.close();
                macResult = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException e) {
                throw new CMSException("exception decoding algorithm parameters.", e);
            }
            BERSet unauthed = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(Collections.unmodifiableMap(parameters)).toASN1EncodableVector()) : null;
            ContentInfo eci = new ContentInfo(CMSObjectIdentifiers.data, (ASN1Encodable)encContent);
            authData = new AuthenticatedData(this.originatorInfo, (ASN1Set)new DERSet(recipientInfos), macCalculator.getAlgorithmIdentifier(), digestCalculator.getAlgorithmIdentifier(), eci, (ASN1Set)authed, (ASN1OctetString)macResult, (ASN1Set)unauthed);
        } else {
            DEROctetString macResult;
            BEROctetString encContent;
            try {
                bOut = new ByteArrayOutputStream();
                TeeOutputStream mOut = new TeeOutputStream((OutputStream)bOut, macCalculator.getOutputStream());
                typedData.write((OutputStream)mOut);
                mOut.close();
                encContent = new BEROctetString(bOut.toByteArray());
                macResult = new DEROctetString(macCalculator.getMac());
            }
            catch (IOException e) {
                throw new CMSException("exception decoding algorithm parameters.", e);
            }
            BERSet unauthed = this.unauthGen != null ? new BERSet(this.unauthGen.getAttributes(new HashMap()).toASN1EncodableVector()) : null;
            ContentInfo eci = new ContentInfo(CMSObjectIdentifiers.data, (ASN1Encodable)encContent);
            authData = new AuthenticatedData(this.originatorInfo, (ASN1Set)new DERSet(recipientInfos), macCalculator.getAlgorithmIdentifier(), null, eci, null, (ASN1OctetString)macResult, (ASN1Set)unauthed);
        }
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.authenticatedData, (ASN1Encodable)authData);
        return new CMSAuthenticatedData(contentInfo, new DigestCalculatorProvider(){

            public DigestCalculator get(AlgorithmIdentifier digestAlgorithmIdentifier) throws OperatorCreationException {
                return digestCalculator;
            }
        });
    }

    public CMSAuthenticatedDataGenerator(SecureRandom rand) {
        super(rand);
    }

    private CMSAuthenticatedData generate(final CMSProcessable content, String macOID, KeyGenerator keyGen, Provider provider) throws NoSuchAlgorithmException, CMSException {
        Provider encProvider = keyGen.getProvider();
        this.convertOldRecipients(this.rand, provider);
        return this.generate(new CMSTypedData(){

            public ASN1ObjectIdentifier getContentType() {
                return CMSObjectIdentifiers.data;
            }

            public void write(OutputStream out) throws IOException, CMSException {
                content.write(out);
            }

            public Object getContent() {
                return content;
            }
        }, new JceCMSMacCalculatorBuilder(new ASN1ObjectIdentifier(macOID)).setProvider(encProvider).setSecureRandom(this.rand).build());
    }

    public CMSAuthenticatedData generate(CMSProcessable content, String macOID, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, macOID, CMSUtils.getProvider(provider));
    }

    public CMSAuthenticatedData generate(CMSProcessable content, String encryptionOID, Provider provider) throws NoSuchAlgorithmException, CMSException {
        KeyGenerator keyGen = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(encryptionOID, provider);
        return this.generate(content, encryptionOID, keyGen, provider);
    }
}

