/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.glass.ui.monocle;

import java.util.Arrays;

class RunnableQueue {
    private Runnable[] queue = new Runnable[32];
    private int start;
    private int count;

    RunnableQueue() {
    }

    private int modulo(int index) {
        if (index >= this.queue.length) {
            index -= this.queue.length;
        }
        return index;
    }

    synchronized void postRunnable(Runnable r) {
        if (this.count == this.queue.length) {
            Runnable[] newQueue = new Runnable[this.queue.length * 3 / 2];
            System.arraycopy(this.queue, this.start, newQueue, 0, this.queue.length - this.start);
            System.arraycopy(this.queue, 0, newQueue, this.queue.length - this.start, this.start);
            this.queue = newQueue;
            this.start = 0;
        }
        this.queue[this.modulo((int)(this.start + this.count))] = r;
        ++this.count;
        this.notifyAll();
    }

    synchronized Runnable getNextRunnable() throws InterruptedException {
        while (this.count == 0) {
            this.wait();
        }
        Runnable r = this.queue[this.start];
        this.queue[this.start] = null;
        this.start = this.modulo(this.start + 1);
        --this.count;
        return r;
    }

    synchronized void clear() {
        Arrays.fill(this.queue, null);
        this.count = 0;
    }
}

