/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.glass.ui.monocle;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.WritableByteChannel;

class Framebuffer {
    private ByteBuffer bb;
    private int width;
    private int height;
    private int byteDepth;
    private boolean receivedData;
    private ByteBuffer clearBuffer;
    private ByteBuffer lineByteBuffer;
    private Buffer linePixelBuffer;
    private int address;

    Framebuffer(ByteBuffer bb, int width, int height, int depth, boolean clear) {
        this.bb = bb;
        this.width = width;
        this.height = height;
        this.byteDepth = depth >>> 3;
        if (clear) {
            this.clearBuffer = ByteBuffer.allocate(width * 4);
        }
    }

    ByteBuffer getBuffer() {
        this.bb.clear();
        return this.bb;
    }

    void reset() {
        this.receivedData = false;
    }

    void setStartAddress(int address) {
        this.address = address;
    }

    void clearBufferContents() {
        this.bb.clear();
        this.bb.position(this.address);
        this.bb.limit(this.address + this.width * this.height * 4);
        for (int i = 0; i < this.height; ++i) {
            this.clearBuffer.clear();
            this.bb.put(this.clearBuffer);
        }
    }

    boolean hasReceivedData() {
        return this.receivedData;
    }

    void composePixels(Buffer src, int pX, int pY, int pW, int pH, float alpha) {
        int stride = pW * 4;
        int start = 0;
        if (pX < 0) {
            start -= pX * 4;
            pW += pX;
            pX = 0;
        }
        if (pY < 0) {
            start -= pY * stride;
            pH += pY;
            pY = 0;
        }
        if (pX + pW > this.width) {
            pW = this.width - pX;
        }
        if (pY + pH > this.height) {
            pH = this.height - pY;
        }
        int alphaMultiplier = Math.round(Math.min(alpha, 1.0f) * 256.0f);
        if (pW < 0 || pH < 0 || alphaMultiplier <= 0) {
            return;
        }
        if (!(this.receivedData || this.clearBuffer == null || alphaMultiplier >= 256 && start == 0 && pW == this.width && pH == this.height)) {
            this.clearBufferContents();
        }
        this.bb.position(this.address + pX * 4 + pY * this.width * 4);
        this.bb.limit(this.bb.capacity());
        if (this.receivedData) {
            IntBuffer srcPixels = src instanceof IntBuffer ? (IntBuffer)src : ((ByteBuffer)src).asIntBuffer();
            IntBuffer dstPixels = this.bb.asIntBuffer();
            for (int i = 0; i < pH; ++i) {
                int j;
                int dstPosition = i * this.width;
                int srcPosition = start + i * stride >> 2;
                if (alphaMultiplier >= 255) {
                    for (j = 0; j < pW; ++j) {
                        int srcPixel = srcPixels.get(srcPosition + j);
                        int srcA = srcPixel >> 24 & 0xFF;
                        if (srcA == 255) {
                            dstPixels.put(dstPosition + j, srcPixel);
                            continue;
                        }
                        dstPixels.put(dstPosition + j, Framebuffer.blend32(srcPixel, dstPixels.get(dstPosition + j), 256));
                    }
                    continue;
                }
                for (j = 0; j < pW; ++j) {
                    dstPixels.put(dstPosition + j, Framebuffer.blend32(srcPixels.get(srcPosition + j), dstPixels.get(dstPosition + j), alphaMultiplier));
                }
            }
        } else if (pW == this.width) {
            if (src instanceof ByteBuffer) {
                src.position(start);
                src.limit(stride * pH);
                this.bb.put((ByteBuffer)src);
            } else {
                IntBuffer srcPixels = (IntBuffer)src;
                srcPixels.position(start >> 2);
                srcPixels.limit(stride * pH >> 2);
                this.bb.asIntBuffer().put(srcPixels);
            }
        } else if (src instanceof ByteBuffer) {
            for (int i = 0; i < pH; ++i) {
                this.bb.position(this.address + pX * 4 + (pY + i) * this.width * 4);
                src.limit(start + i * stride + pW * 4);
                src.position(start + i * stride);
                this.bb.put((ByteBuffer)src);
            }
        } else {
            this.bb.position(this.address);
            this.bb.limit(this.address + this.width * this.height * 4);
            IntBuffer dstPixels = this.bb.asIntBuffer();
            IntBuffer srcPixels = (IntBuffer)src;
            for (int i = 0; i < pH; ++i) {
                dstPixels.position(pX + (pY + i) * this.width);
                srcPixels.limit(pW + (start + i * stride >> 2));
                srcPixels.position(start + i * stride >> 2);
                dstPixels.put((IntBuffer)src);
            }
        }
        this.receivedData = true;
    }

    private static int blend32(int src, int dst, int alphaMultiplier) {
        int srcA = (src >> 24 & 0xFF) * alphaMultiplier >> 8;
        int srcR = src >> 16 & 0xFF;
        int srcG = src >> 8 & 0xFF;
        int srcB = src & 0xFF;
        int dstA = dst >> 24 & 0xFF;
        int dstR = dst >> 16 & 0xFF;
        int dstG = dst >> 8 & 0xFF;
        int dstB = dst & 0xFF;
        dstR = srcR * srcA / 255 + dstR * dstA * (255 - srcA) / 65280;
        dstG = srcG * srcA / 255 + dstG * dstA * (255 - srcA) / 65280;
        dstB = srcB * srcA / 255 + dstB * dstA * (255 - srcA) / 65280;
        dstA = srcA + dstA * (255 - srcA) / 255;
        return dstA << 24 | dstR << 16 | dstG << 8 | dstB;
    }

    void write(WritableByteChannel out) throws IOException {
        this.bb.clear();
        if (this.byteDepth == 4) {
            out.write(this.bb);
        } else if (this.byteDepth == 2) {
            if (this.lineByteBuffer == null) {
                this.lineByteBuffer = ByteBuffer.allocate(this.width * 2);
                this.lineByteBuffer.order(ByteOrder.nativeOrder());
                this.linePixelBuffer = this.lineByteBuffer.asShortBuffer();
            }
            IntBuffer srcPixels = this.bb.asIntBuffer();
            ShortBuffer shortBuffer = (ShortBuffer)this.linePixelBuffer;
            for (int i = 0; i < this.height; ++i) {
                shortBuffer.clear();
                for (int j = 0; j < this.width; ++j) {
                    int pixel32 = srcPixels.get();
                    int r = (pixel32 >> 19 & 0x1F) * 539219 >> 8 & 0xF800;
                    int g = (pixel32 >> 10 & 0x3F) * 265395 >> 13 & 0x7E0;
                    int b = (pixel32 >> 3 & 0x1F) * 539219 >> 19;
                    int pixel16 = r | g | b;
                    shortBuffer.put((short)pixel16);
                }
                this.lineByteBuffer.clear();
                out.write(this.lineByteBuffer);
            }
        }
    }

    void copyToBuffer(ByteBuffer out) {
        this.bb.clear();
        if (this.byteDepth == 4) {
            out.put(this.bb);
        } else if (this.byteDepth == 2) {
            if (this.lineByteBuffer == null) {
                this.lineByteBuffer = ByteBuffer.allocate(this.width * 2);
                this.lineByteBuffer.order(ByteOrder.nativeOrder());
                this.linePixelBuffer = this.lineByteBuffer.asShortBuffer();
            }
            IntBuffer srcPixels = this.bb.asIntBuffer();
            ShortBuffer shortBuffer = (ShortBuffer)this.linePixelBuffer;
            for (int i = 0; i < this.height; ++i) {
                shortBuffer.clear();
                for (int j = 0; j < this.width; ++j) {
                    int pixel32 = srcPixels.get();
                    int r = (pixel32 >> 19 & 0x1F) * 539219 >> 8 & 0xF800;
                    int g = (pixel32 >> 10 & 0x3F) * 265395 >> 13 & 0x7E0;
                    int b = (pixel32 >> 3 & 0x1F) * 539219 >> 19;
                    int pixel16 = r | g | b;
                    shortBuffer.put((short)pixel16);
                }
                this.lineByteBuffer.clear();
                out.put(this.lineByteBuffer);
            }
        }
    }
}

