/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.multipart;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.common.testing.FakeHttpServletRequest;
import org.apache.shindig.protocol.multipart.DefaultMultipartFormParser;
import org.apache.shindig.protocol.multipart.FormDataItem;
import org.apache.shindig.protocol.multipart.MultipartFormParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultMultipartFormParserTest
extends Assert {
    private static final String REQUEST_FIELDNAME = "request";
    private static final String REQUEST_DATA = "{name: 'HelloWorld'}";
    private static final String ALBUM_IMAGE_FIELDNAME = "album-image";
    private static final String ALBUM_IMAGE_FILENAME = "album-image.jpg";
    private static final String ALBUM_IMAGE_DATA = "album image data";
    private static final String ALBUM_IMAGE_TYPE = "image/jpeg";
    private static final String PROFILE_IMAGE_FIELDNAME = "profile-image";
    private static final String PROFILE_IMAGE_FILENAME = "profile-image.jpg";
    private static final String PROFILE_IMAGE_DATA = "profile image data";
    private static final String PROFILE_IMAGE_TYPE = "image/png";
    private MultipartFormParser multipartFormParser;
    private HttpServletRequest request;

    @Before
    public void setUp() throws Exception {
        this.multipartFormParser = new DefaultMultipartFormParser();
    }

    @Test
    public void testIsMultipartContent() {
        FakeHttpServletRequest request = new FakeHttpServletRequest();
        request.setMethod("GET");
        DefaultMultipartFormParserTest.assertFalse((boolean)this.multipartFormParser.isMultipartContent((HttpServletRequest)request));
        request.setMethod("POST");
        DefaultMultipartFormParserTest.assertFalse((boolean)this.multipartFormParser.isMultipartContent((HttpServletRequest)request));
        request.setContentType("multipart/form-data");
        DefaultMultipartFormParserTest.assertTrue((boolean)this.multipartFormParser.isMultipartContent((HttpServletRequest)request));
        request.setMethod("GET");
        DefaultMultipartFormParserTest.assertFalse((boolean)this.multipartFormParser.isMultipartContent((HttpServletRequest)request));
    }

    private void setupRequest(byte[] postData, String contentType) throws IOException {
        FakeHttpServletRequest fakeReq = new FakeHttpServletRequest("/social/rest", "", "");
        fakeReq.setPostData(postData);
        fakeReq.setContentType(contentType);
        this.request = fakeReq;
    }

    @Test
    public void testSingleFileItem() throws Exception {
        MultipartFormBuilder builder = new MultipartFormBuilder();
        builder.addFileItem(ALBUM_IMAGE_FIELDNAME, ALBUM_IMAGE_FILENAME, ALBUM_IMAGE_DATA, ALBUM_IMAGE_TYPE);
        this.setupRequest(builder.build(), builder.getContentType());
        ArrayList formItems = Lists.newArrayList((Iterable)this.multipartFormParser.parse(this.request));
        DefaultMultipartFormParserTest.assertEquals((long)1L, (long)formItems.size());
        FormDataItem formItem = (FormDataItem)formItems.get(0);
        DefaultMultipartFormParserTest.assertFalse((boolean)formItem.isFormField());
        DefaultMultipartFormParserTest.assertEquals((Object)ALBUM_IMAGE_FIELDNAME, (Object)formItem.getFieldName());
        DefaultMultipartFormParserTest.assertEquals((Object)ALBUM_IMAGE_FILENAME, (Object)formItem.getName());
        DefaultMultipartFormParserTest.assertEquals((Object)ALBUM_IMAGE_TYPE, (Object)formItem.getContentType());
        DefaultMultipartFormParserTest.assertEquals((Object)ALBUM_IMAGE_DATA, (Object)new String(formItem.get()));
    }

    @Test
    public void testSingleRequest() throws Exception {
        MultipartFormBuilder builder = new MultipartFormBuilder();
        builder.addFormField(REQUEST_FIELDNAME, REQUEST_DATA);
        this.setupRequest(builder.build(), builder.getContentType());
        ArrayList formItems = Lists.newArrayList((Iterable)this.multipartFormParser.parse(this.request));
        DefaultMultipartFormParserTest.assertEquals((long)1L, (long)formItems.size());
        FormDataItem formItem = (FormDataItem)formItems.get(0);
        DefaultMultipartFormParserTest.assertTrue((boolean)formItem.isFormField());
        DefaultMultipartFormParserTest.assertEquals((Object)REQUEST_FIELDNAME, (Object)formItem.getFieldName());
        DefaultMultipartFormParserTest.assertEquals((Object)REQUEST_DATA, (Object)new String(formItem.get()));
    }

    @Test
    public void testSingleFileItemAndRequest() throws Exception {
        MultipartFormBuilder builder = new MultipartFormBuilder();
        builder.addFileItem(ALBUM_IMAGE_FIELDNAME, ALBUM_IMAGE_FILENAME, ALBUM_IMAGE_DATA, ALBUM_IMAGE_TYPE);
        builder.addFormField(REQUEST_FIELDNAME, REQUEST_DATA);
        this.setupRequest(builder.build(), builder.getContentType());
        ArrayList formItems = Lists.newArrayList((Iterable)this.multipartFormParser.parse(this.request));
        DefaultMultipartFormParserTest.assertEquals((long)2L, (long)formItems.size());
        FormDataItem formItem = (FormDataItem)formItems.get(0);
        DefaultMultipartFormParserTest.assertFalse((boolean)formItem.isFormField());
        DefaultMultipartFormParserTest.assertEquals((Object)ALBUM_IMAGE_FIELDNAME, (Object)formItem.getFieldName());
        DefaultMultipartFormParserTest.assertEquals((Object)ALBUM_IMAGE_FILENAME, (Object)formItem.getName());
        DefaultMultipartFormParserTest.assertEquals((Object)ALBUM_IMAGE_TYPE, (Object)formItem.getContentType());
        DefaultMultipartFormParserTest.assertEquals((Object)ALBUM_IMAGE_DATA, (Object)new String(formItem.get()));
        formItem = (FormDataItem)formItems.get(1);
        DefaultMultipartFormParserTest.assertTrue((boolean)formItem.isFormField());
        DefaultMultipartFormParserTest.assertEquals((Object)REQUEST_FIELDNAME, (Object)formItem.getFieldName());
        DefaultMultipartFormParserTest.assertEquals((Object)REQUEST_DATA, (Object)new String(formItem.get()));
    }

    @Test
    public void testMultipleFileItemAndRequest() throws Exception {
        MultipartFormBuilder builder = new MultipartFormBuilder();
        builder.addFileItem(ALBUM_IMAGE_FIELDNAME, ALBUM_IMAGE_FILENAME, ALBUM_IMAGE_DATA, ALBUM_IMAGE_TYPE);
        builder.addFormField(REQUEST_FIELDNAME, REQUEST_DATA);
        builder.addFileItem(PROFILE_IMAGE_FIELDNAME, PROFILE_IMAGE_FILENAME, PROFILE_IMAGE_DATA, PROFILE_IMAGE_TYPE);
        this.setupRequest(builder.build(), builder.getContentType());
        ArrayList formItems = Lists.newArrayList((Iterable)this.multipartFormParser.parse(this.request));
        DefaultMultipartFormParserTest.assertEquals((long)3L, (long)formItems.size());
        FormDataItem formItem = (FormDataItem)formItems.get(0);
        DefaultMultipartFormParserTest.assertFalse((boolean)formItem.isFormField());
        DefaultMultipartFormParserTest.assertEquals((Object)ALBUM_IMAGE_FIELDNAME, (Object)formItem.getFieldName());
        DefaultMultipartFormParserTest.assertEquals((Object)ALBUM_IMAGE_FILENAME, (Object)formItem.getName());
        DefaultMultipartFormParserTest.assertEquals((Object)ALBUM_IMAGE_TYPE, (Object)formItem.getContentType());
        DefaultMultipartFormParserTest.assertEquals((Object)ALBUM_IMAGE_DATA, (Object)new String(formItem.get()));
        formItem = (FormDataItem)formItems.get(1);
        DefaultMultipartFormParserTest.assertTrue((boolean)formItem.isFormField());
        DefaultMultipartFormParserTest.assertEquals((Object)REQUEST_FIELDNAME, (Object)formItem.getFieldName());
        DefaultMultipartFormParserTest.assertEquals((Object)REQUEST_DATA, (Object)new String(formItem.get()));
        formItem = (FormDataItem)formItems.get(2);
        DefaultMultipartFormParserTest.assertFalse((boolean)formItem.isFormField());
        DefaultMultipartFormParserTest.assertEquals((Object)PROFILE_IMAGE_FIELDNAME, (Object)formItem.getFieldName());
        DefaultMultipartFormParserTest.assertEquals((Object)PROFILE_IMAGE_FILENAME, (Object)formItem.getName());
        DefaultMultipartFormParserTest.assertEquals((Object)PROFILE_IMAGE_TYPE, (Object)formItem.getContentType());
        DefaultMultipartFormParserTest.assertEquals((Object)PROFILE_IMAGE_DATA, (Object)new String(formItem.get()));
    }

    private static class MultipartFormBuilder {
        private final String boundary;
        private final StringBuilder packet = new StringBuilder();
        private static final String BOUNDARY = "--abcdefgh";

        public MultipartFormBuilder() {
            this(BOUNDARY);
        }

        public MultipartFormBuilder(String boundary) {
            this.boundary = boundary;
        }

        public String getContentType() {
            return "multipart/form-data; boundary=" + this.boundary;
        }

        public byte[] build() {
            this.write("--");
            this.write(this.boundary);
            this.write("--");
            return this.packet.toString().getBytes();
        }

        public void addFileItem(String fieldName, String fileName, String content, String contentType) {
            this.writeBoundary();
            this.write("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + '\"');
            this.write("\r\n");
            this.write("Content-Type: " + contentType);
            this.write("\r\n\r\n");
            this.write(content);
            this.write("\r\n");
        }

        public void addFormField(String fieldName, String content) {
            this.addFormField(fieldName, content, null);
        }

        public void addFormField(String fieldName, String content, String contentType) {
            this.writeBoundary();
            this.write("Content-Disposition: form-data; name=\"" + fieldName + '\"');
            if (contentType != null) {
                this.write("\r\n");
                this.write("Content-Type: " + contentType);
            }
            this.write("\r\n\r\n");
            this.write(content);
            this.write("\r\n");
        }

        private void writeBoundary() {
            this.write("--");
            this.write(this.boundary);
            this.write("\r\n");
        }

        private void write(String content) {
            this.packet.append(content);
        }
    }
}

