/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.common.testing.FakeHttpServletRequest;
import org.apache.shindig.common.util.JsonConversionUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class JsonConversionUtilTest
extends Assert {
    @Test
    public void testSimplePathToJsonParsing() throws Exception {
        JSONObject root = new JSONObject();
        JsonConversionUtil.buildHolder((JSONObject)root, (String[])"a.a.a".split("\\."), (int)0);
        JsonConversionUtilTest.assertJsonEquals(root, new JSONObject("{a:{a:{}}}"));
    }

    @Test
    public void testArrayPathToJsonParsing() throws Exception {
        JSONObject root = new JSONObject();
        JsonConversionUtil.buildHolder((JSONObject)root, (String[])"a.a(0).a".split("\\."), (int)0);
        JsonConversionUtil.buildHolder((JSONObject)root, (String[])"a.a(1).a".split("\\."), (int)0);
        JsonConversionUtil.buildHolder((JSONObject)root, (String[])"a.a(2).a".split("\\."), (int)0);
        JsonConversionUtilTest.assertJsonEquals(root, new JSONObject("{a:{a:[{},{},{}]}}"));
    }

    @Test
    public void testValueToJsonParsing() throws Exception {
        String longNumber = "108502345354398668456";
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)longNumber), longNumber);
        String longDoubleOverflow = "108502345354398668456.1234";
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)longDoubleOverflow), longDoubleOverflow);
        String longDoubleFractionPart = "1.108502345354398668456108502345354398668456";
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)longDoubleFractionPart), longDoubleFractionPart);
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"12345"), 12345);
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"12.345"), 12.345);
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"abc"), "abc");
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"\"a,b,c\""), "a,b,c");
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"true"), true);
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"false"), false);
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"null"), JSONObject.NULL);
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"'abc'"), "abc");
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"a,b,c"), new JSONArray((Collection)Lists.newArrayList((Object[])new String[]{"a", "b", "c"})));
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"1,2,3,true,false,null"), new JSONArray((Collection)Lists.newArrayList((Object[])new Object[]{1, 2, 3, true, false, null})));
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"(1)"), new JSONArray((Collection)Lists.newArrayList((Object[])new Integer[]{1})));
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.convertToJsonValue((String)"(true)"), new JSONArray((Collection)Lists.newArrayList((Object[])new Boolean[]{true})));
    }

    @Test
    public void testParameterMapToJsonParsing() throws Exception {
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"1")), new JSONObject("{a:{b:{c:1}}}"));
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"\"1\"")), new JSONObject("{a:{b:{c:\"1\"}}}"));
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"true")), new JSONObject("{a:{b:{c:true}}}"));
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"false")), new JSONObject("{a:{b:{c:false}}}"));
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"null")), new JSONObject("{a:{b:{c:null}}}"));
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b(0).c", (Object)"hello", (Object)"a.b(1).c", (Object)"hello")), new JSONObject("{a:{b:[{c:\"hello\"},{c:\"hello\"}]}}"));
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"hello, true, false, null, 1,2, \"null\", \"()\"")), new JSONObject("{a:{b:{c:[\"hello\",true,false,null,1,2,\"null\",\"()\"]}}}"));
        JsonConversionUtilTest.assertJsonEquals(JsonConversionUtil.parametersToJsonObject((Map)ImmutableMap.of((Object)"a.b.c", (Object)"\"hello, true, false, null, 1,2\"")), new JSONObject("{a:{b:{c:\"hello, true, false, null, 1,2\"}}}"));
    }

    @Test
    public void testJSONToParameterMapParsing() throws Exception {
        Map resultMap = JsonConversionUtil.fromJson((JSONObject)new JSONObject("{a:{b:[{c:\"hello\"},{c:\"hello\"}]}}"));
        JsonConversionUtilTest.assertEquals((long)2L, (long)resultMap.size());
        JsonConversionUtilTest.assertEquals((Object)"hello", resultMap.get(".a.b(0).c"));
        JsonConversionUtilTest.assertEquals((Object)"hello", resultMap.get(".a.b(1).c"));
    }

    @Test
    public void testJsonFromRequest() throws Exception {
        for (String badParms : ImmutableList.of((Object)"x=1", (Object)"x=1&callback=")) {
            FakeHttpServletRequest fakeRequest = new FakeHttpServletRequest("http://foo.com/gadgets/rpc?" + badParms);
            JsonConversionUtilTest.assertNull((Object)JsonConversionUtil.fromRequest((HttpServletRequest)fakeRequest));
        }
    }

    public static void assertJsonEquals(Object expected, Object actual) throws JSONException {
        if (expected == null) {
            JsonConversionUtilTest.assertNull((Object)actual);
            return;
        }
        JsonConversionUtilTest.assertNotNull((Object)actual);
        if (expected instanceof JSONObject) {
            JSONObject expectedObject = (JSONObject)expected;
            JSONObject actualObject = (JSONObject)actual;
            if (expectedObject.length() == 0) {
                JsonConversionUtilTest.assertEquals((long)expectedObject.length(), (long)actualObject.length());
                return;
            }
            JsonConversionUtilTest.assertEquals((long)expectedObject.names().length(), (long)actualObject.names().length());
            for (String key : JSONObject.getNames((JSONObject)expectedObject)) {
                JsonConversionUtilTest.assertTrue((String)("missing key " + key), (boolean)actualObject.has(key));
                JsonConversionUtilTest.assertJsonEquals(expectedObject.get(key), actualObject.get(key));
            }
        } else if (expected instanceof JSONArray) {
            JSONArray expectedArray = (JSONArray)expected;
            JSONArray actualArray = (JSONArray)actual;
            JsonConversionUtilTest.assertEquals((long)expectedArray.length(), (long)actualArray.length());
            for (int i = 0; i < expectedArray.length(); ++i) {
                if (expectedArray.isNull(i)) {
                    JsonConversionUtilTest.assertTrue((boolean)actualArray.isNull(i));
                    continue;
                }
                JsonConversionUtilTest.assertJsonEquals(expectedArray.get(i), actualArray.get(i));
            }
        } else {
            JsonConversionUtilTest.assertEquals((Object)expected, (Object)actual);
        }
    }
}

