/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.servlet;

import org.apache.shindig.common.servlet.UserAgent;
import org.junit.Assert;
import org.junit.Test;

public class UserAgentTest
extends Assert {
    private UserAgent getUaEntry(String version) {
        return new UserAgent(UserAgent.Browser.OTHER, version);
    }

    @Test
    public void testVersionNumberParsingStandard() {
        UserAgentTest.assertEquals((double)3.0, (double)this.getUaEntry("3").getVersionNumber(), (double)0.0);
    }

    @Test
    public void testVersionNumberParsingStandardDecimal() {
        UserAgentTest.assertEquals((double)3.1415, (double)this.getUaEntry("3.1415").getVersionNumber(), (double)0.0);
    }

    @Test
    public void testVersionNumberParsingMultiPart() {
        UserAgentTest.assertEquals((double)3.1, (double)this.getUaEntry("3.1.5").getVersionNumber(), (double)0.0);
    }

    @Test
    public void testVersionNumberParsingAlphaSuffix() {
        UserAgentTest.assertEquals((double)4.5, (double)this.getUaEntry("4.5beta2").getVersionNumber(), (double)0.0);
    }

    @Test
    public void testVersionNumberParsingEmbeddedInTheMiddle() {
        UserAgentTest.assertEquals((double)1.5, (double)this.getUaEntry("beta 1.5 rc 5").getVersionNumber(), (double)0.0);
    }
}

