/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder;

import android.content.Context;
import android.view.View;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.uicomponents.list.header.DateHeaderUtilsKt;
import com.liveperson.infra.ui.view.adapter.viewholder.MiddleViewHolder;
import com.liveperson.infra.utils.DateUtils;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u0012\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/liveperson/infra/messaging_ui/view/adapter/viewholder/DateHeaderViewHolder;", "Lcom/liveperson/infra/ui/view/adapter/viewholder/MiddleViewHolder;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "applyColors", "", "getUpdateDelay", "", "onUpdateTimestampText", "setContentDescription", "message", "", "shouldUpdateTimestamps", "", "updateContentDescription", "Companion", "messaging_ui_release"})
public final class DateHeaderViewHolder
extends MiddleViewHolder {
    private static final long DAY_IN_MILLIS;
    public static final Companion Companion;

    public void setContentDescription(@Nullable String message) {
        View view = this.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
        view.setContentDescription((CharSequence)message);
    }

    public void updateContentDescription() {
        View view = this.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"itemView");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"itemView.context");
        String text = DateHeaderUtilsKt.getFormattedTimestamp(context, this.mTimeStamp);
        this.setMessageTextView(text);
        this.setContentDescription(text);
    }

    public void onUpdateTimestampText() {
        this.updateContentDescription();
    }

    public void applyColors() {
    }

    public long getUpdateDelay() {
        return DAY_IN_MILLIS + this.mTimeStamp - System.currentTimeMillis();
    }

    protected boolean shouldUpdateTimestamps() {
        boolean isNumericTimestamp = Configuration.getBoolean((int)R.bool.message_status_numeric_timestamp_only);
        boolean isAppropriateDay = DateUtils.isToday((long)this.mTimeStamp) || DateUtils.isTomorrow((long)this.mTimeStamp);
        return this.isTimestampEnabled() && !isNumericTimestamp && isAppropriateDay;
    }

    public DateHeaderViewHolder(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super(view);
    }

    static {
        Companion = new Companion(null);
        DAY_IN_MILLIS = TimeUnit.DAYS.toMillis(1L);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/infra/messaging_ui/view/adapter/viewholder/DateHeaderViewHolder$Companion;", "", "()V", "DAY_IN_MILLIS", "", "messaging_ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

