/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder;

import android.view.View;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsConsumerViewHolder;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.Form;
import com.liveperson.messaging.model.MessagingChatMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class AmsConsumerFormSubmissionViewHolder
extends AmsConsumerViewHolder {
    private static final String TAG = "AmsConsumerFormSubmissionViewHolder";
    private String mFormTitle;

    public AmsConsumerFormSubmissionViewHolder(View itemView, MessagingChatMessage.MessageType messageType) {
        super(itemView, messageType);
        this.mMessageTextView.setText((CharSequence)String.format(itemView.getResources().getString(R.string.lpmessaging_ui_secure_form_consumer_submitted_message), this.mFormTitle));
    }

    @Override
    public void setMessageText(String text, boolean enabled) {
        try {
            JSONObject jo = new JSONObject(text);
            String id2 = jo.getString("invitationId");
            Form form = MessagingFactory.getInstance().getController().amsMessages.mFormsManager.getForm(id2);
            this.mFormTitle = form != null ? form.getFormTitle() : jo.getString("formTitle");
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000010D, "Error parsing message JSON. Original text: " + LPLog.INSTANCE.mask((Object)text), (Throwable)e);
        }
        this.mMessageTextView.setText((CharSequence)String.format(this.itemView.getResources().getString(R.string.lpmessaging_ui_secure_form_consumer_submitted_message), this.mFormTitle));
    }

    @Override
    public void applyColors() {
    }
}

