/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.liveperson.infra.database.tables.FilesTable;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsConsumerViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsDownloadableFileViewProcessor;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.utils.FileSharingUtils;
import java.io.File;

public class AmsConsumerFileViewHolder
extends AmsConsumerViewHolder {
    public static final String TAG = "AmsConsumerFileViewHolder";
    private ImageView mMessageImageView;
    protected ImageView mFileStatusView;
    protected AmsDownloadableFileViewProcessor mDownloadableFileViewProcessor;
    private int mDocumentImageResourceId;
    private boolean mIsDocumentType;
    protected MessagingChatMessage.MessageType mMessageType;
    private RelativeLayout mConsumerViewHolder;

    public AmsConsumerFileViewHolder(View itemView, MessagingChatMessage.MessageType messageType) {
        super(itemView, messageType);
        this.mMessageImageView = (ImageView)itemView.findViewById(R.id.lpui_message_image);
        this.mFileStatusView = (ImageView)itemView.findViewById(R.id.lpui_message_status_image);
        this.mConsumerViewHolder = (RelativeLayout)itemView.findViewById(R.id.lpui_consumer_view_holder);
        this.mMessageType = messageType;
        this.mDownloadableFileViewProcessor = new AmsDownloadableFileViewProcessor(itemView, messageType){

            @Override
            protected void onNotStartedAction() {
                AmsConsumerFileViewHolder.this.mDownloadableFileViewProcessor.stopAnimation();
                AmsConsumerFileViewHolder.this.mDownloadableFileViewProcessor.mFileStatusView.setVisibility(0);
                AmsConsumerFileViewHolder.this.mDownloadableFileViewProcessor.mFileStatusView.setImageResource(R.drawable.lpmessaging_ui_image_download);
            }

            @Override
            protected void onCompletedAction() {
                AmsConsumerFileViewHolder.this.mDownloadableFileViewProcessor.stopAnimation();
                AmsConsumerFileViewHolder.this.mDownloadableFileViewProcessor.mFileStatusView.setVisibility(4);
            }

            @Override
            protected void onRequestingUrlAction() {
                AmsConsumerFileViewHolder.this.mDownloadableFileViewProcessor.mFileStatusView.setVisibility(0);
                AmsConsumerFileViewHolder.this.mDownloadableFileViewProcessor.startProgressBar();
            }
        };
    }

    @Override
    public void applyChanges(Bundle changes, Message message) {
        super.applyChanges(changes, message);
        this.mDownloadableFileViewProcessor.applyChanges(changes);
        LPLog.INSTANCE.d(TAG, "File type: " + this.mDownloadableFileViewProcessor.mFileTpe);
        if (!TextUtils.isEmpty((CharSequence)this.mDownloadableFileViewProcessor.mFileTpe)) {
            this.setIsDocumentType(this.mDownloadableFileViewProcessor.mFileTpe);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mDownloadableFileViewProcessor.mPreviewImage)) {
            this.setMessageImage(Uri.parse((String)this.mDownloadableFileViewProcessor.mPreviewImage));
        } else if (!TextUtils.isEmpty((CharSequence)this.mDownloadableFileViewProcessor.mFullFile)) {
            this.setMessageImageNoPlaceholder(Uri.parse((String)this.mDownloadableFileViewProcessor.mFullFile));
        }
    }

    @Override
    public void setMessageText(String text, boolean enabled) {
        super.setMessageText(text, enabled);
        if (TextUtils.isEmpty((CharSequence)text)) {
            this.mMessageTextView.setVisibility(8);
        } else {
            this.mMessageTextView.setVisibility(0);
        }
    }

    public void setMessageImage(String fullImagePath, String previewUri, FilesTable.LoadStatus loadStatus, String fileType) {
        this.setIsDocumentType(fileType);
        if (!TextUtils.isEmpty((CharSequence)previewUri) || this.mIsDocumentType) {
            Uri uri = TextUtils.isEmpty((CharSequence)previewUri) ? null : Uri.parse((String)previewUri);
            this.setMessageImage(uri);
            this.mDownloadableFileViewProcessor.applyLoadStatusForDownloadFlow(loadStatus);
        } else if (!TextUtils.isEmpty((CharSequence)fullImagePath)) {
            this.setMessageImage(Uri.parse((String)fullImagePath));
            this.mDownloadableFileViewProcessor.applyLoadStatusForUploadFlow(loadStatus);
        } else {
            this.mDownloadableFileViewProcessor.applyLoadStatusForDownloadFlow(FilesTable.LoadStatus.PREVIEW_ERROR);
            this.mMessageImageView.setImageResource(R.drawable.lp_messaging_ui_icon_image_broken);
        }
    }

    @Override
    protected int resend(Message message, MessagingChatMessage.MessageType messageType) {
        return MessagingFactory.getInstance().getController().resendMessage(message.getEventId(), message.getDialogId(), this.mDownloadableFileViewProcessor.mFileRowId, messageType);
    }

    private void setMessageImage(Uri imageUri) {
        try {
            Resources resources = this.mFileStatusView.getContext().getResources();
            Resources.Theme theme = this.mFileStatusView.getContext().getTheme();
            VectorDrawableCompat drawable2 = VectorDrawableCompat.create((Resources)resources, (int)R.drawable.lpmessaging_ui_image_light_large, (Resources.Theme)theme);
            if (this.mIsDocumentType && this.mDocumentImageResourceId != 0) {
                this.mMessageImageView.setImageResource(this.mDocumentImageResourceId);
            } else {
                PicassoUtils.get((Context)this.itemView.getContext()).load(new File(imageUri.getPath())).error(R.drawable.lp_messaging_ui_icon_image_broken).placeholder((Drawable)drawable2).centerCrop().fit().into(this.mMessageImageView);
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000112, "Failed to set message image: ", (Throwable)e);
        }
    }

    private void setMessageImageNoPlaceholder(Uri imageUri) {
        if (this.mIsDocumentType && this.mDocumentImageResourceId != 0) {
            this.mMessageImageView.setImageResource(this.mDocumentImageResourceId);
        } else {
            LPLog.INSTANCE.d(TAG, "At setMessageImageNoPlaceholder: " + this.mIsDocumentType + " " + this.mDocumentImageResourceId);
            PicassoUtils.get((Context)this.itemView.getContext()).load(new File(imageUri.getPath())).error(R.drawable.lp_messaging_ui_icon_image_broken).noPlaceholder().centerCrop().fit().into(this.mMessageImageView);
        }
    }

    public void setImageClickListener(View.OnClickListener onClickListener) {
        if (this.mMessageImageView != null) {
            this.mMessageImageView.setOnClickListener(onClickListener);
        }
        if (this.mConsumerViewHolder != null) {
            this.mConsumerViewHolder.setOnClickListener(onClickListener);
        }
    }

    public void setImageLongClickListener(View.OnLongClickListener onLongClickListener) {
        if (this.mMessageImageView != null) {
            this.mMessageImageView.setOnLongClickListener(onLongClickListener);
        }
        if (this.mConsumerViewHolder != null) {
            this.mConsumerViewHolder.setOnLongClickListener(onLongClickListener);
        }
    }

    private void setIsDocumentType(String fileType) {
        FileSharingType fileSharingType = FileSharingType.getFileTypeFromExtension((String)fileType.toLowerCase());
        if (FileSharingUtils.isDocumentType((FileSharingType)fileSharingType)) {
            this.mIsDocumentType = true;
            switch (fileSharingType) {
                case PDF: {
                    this.mDocumentImageResourceId = R.drawable.lp_pdf_thumbnail;
                    break;
                }
                case DOCX: {
                    this.mDocumentImageResourceId = R.drawable.lp_docx_thumbnail;
                    break;
                }
                case XLSX: {
                    this.mDocumentImageResourceId = R.drawable.lp_xlsx_thumbnail;
                    break;
                }
                case PPTX: {
                    this.mDocumentImageResourceId = R.drawable.lp_pptx_thumbnail;
                    break;
                }
                default: {
                    this.mDocumentImageResourceId = R.drawable.lp_messaging_ui_icon_image_broken;
                    break;
                }
            }
        } else {
            this.mIsDocumentType = false;
        }
    }

    @Override
    public void updateContentDescription() {
        Context context = this.getContext();
        if (context != null) {
            String youWord = context.getResources().getString(R.string.lp_accessibility_you);
            String fileType = this.mMessageType == MessagingChatMessage.MessageType.CONSUMER_DOCUMENT ? context.getResources().getString(R.string.lp_accessibility_file) : context.getResources().getString(R.string.lp_accessibility_photo);
            String errorMessage = context.getResources().getString(R.string.lp_accessibility_resend) + " " + fileType;
            String statusDescription = this.getStatusText();
            this.setContentDescription(youWord + ", " + fileType + ": " + this.mMessageTextView.getText().toString() + ", " + this.mTimestampAccessibilityString + " " + statusDescription);
            this.mMessageImageView.setContentDescription((CharSequence)fileType);
            this.mMessageErrorView.setContentDescription((CharSequence)errorMessage);
        }
    }

    public AmsDownloadableFileViewProcessor getAmsDownloadableFileViewProcessor() {
        return this.mDownloadableFileViewProcessor;
    }

    public void recycle() {
        super.recycle();
        this.mMessageImageView.setImageDrawable(null);
    }
}

