/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.copybehavior;

import android.util.SparseArray;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualItemAction;
import com.liveperson.infra.ui.view.adapter.viewholder.BaseViewHolder;
import com.liveperson.messaging.model.FileMessage;
import java.io.File;
import java.util.ArrayList;

public class MessagingContextualActionModeBehavior
extends ContextualActionBehavior
implements ActionMode.Callback,
MenuItem.OnMenuItemClickListener {
    private static final String TAG = MessagingContextualActionModeBehavior.class.getSimpleName();
    private SparseArray<Object> mSelectedItemIds = new SparseArray();
    private boolean mIsSelectable = false;
    private ActionMode mMode;
    private MenuItem copyItem;
    private MenuItem moreItem;

    public MessagingContextualActionModeBehavior(ContextualItemAction contextualItemAction, ArrayList<Integer> bundledViewData, boolean isFileSelected) {
        super(contextualItemAction, bundledViewData, isFileSelected);
    }

    private void addSelectedItem(int itemId, BaseViewHolder viewHolder, FileMessage fileMessage) {
        boolean isChecked = viewHolder.itemView.isSelected();
        Object textOrFilePath = this.hasFilePath(fileMessage) ? new File(fileMessage.getLocalUrl()) : viewHolder.getTextToCopy();
        if (isChecked) {
            this.mSelectedItemIds.put(itemId, textOrFilePath);
            if (!this.mBundledViewData.contains(itemId)) {
                this.mBundledViewData.add(itemId);
            }
        } else {
            this.mSelectedItemIds.delete(itemId);
            this.mBundledViewData.remove((Object)itemId);
        }
        this.enableActionItemsAsRequired();
    }

    @Override
    public ArrayList<Integer> getListOfSelectedItems() {
        return this.mBundledViewData;
    }

    @Override
    public boolean getIfFileSelectedBeforeOrientation() {
        return this.hasFile();
    }

    @Override
    public void setActionMode() {
        if (this.mBundledViewData.size() > 0) {
            this.setSelectable(true);
        }
    }

    private boolean hasFile() {
        if (this.mSelectedItemIds.size() != this.mBundledViewData.size()) {
            return this.mIsFileSelected;
        }
        if (this.mSelectedItemIds != null) {
            for (int i = 0; i < this.mSelectedItemIds.size(); ++i) {
                if (!(this.mSelectedItemIds.get(this.mSelectedItemIds.keyAt(i)) instanceof File)) continue;
                return true;
            }
        }
        return false;
    }

    private void clearAll() {
        this.mSelectedItemIds.clear();
        this.mBundledViewData.clear();
        this.setSelectable(false);
    }

    private boolean isSelected(int itemId) {
        return this.mSelectedItemIds.get(itemId) != null;
    }

    private void setSelectable(boolean selectable) {
        if (this.mIsSelectable == selectable) {
            return;
        }
        this.mIsSelectable = selectable;
        if (selectable) {
            this.mActivityProvider.getActivity().startActionMode((ActionMode.Callback)this);
        } else if (this.mMode != null) {
            this.mMode.finish();
        }
        LPLog.INSTANCE.d(TAG, "set Selectable : " + selectable);
    }

    @Override
    public boolean isSelectable() {
        return this.mIsSelectable;
    }

    public void setOnClickListener(int itemId, BaseViewHolder viewHolder, FileMessage fileMessage) {
        viewHolder.setOnClickListener(v -> this.onViewClick(itemId, viewHolder, fileMessage));
    }

    @Override
    public View.OnClickListener getOnClickListener(int itemId, BaseViewHolder viewHolder, FileMessage fileMessage) {
        return v -> this.onViewClick(itemId, viewHolder, fileMessage);
    }

    private void onViewClick(int itemId, BaseViewHolder viewHolder, FileMessage fileMessage) {
        if (this.isSelectable()) {
            if (fileMessage != null && !this.hasFilePath(fileMessage)) {
                return;
            }
            viewHolder.itemView.setSelected(!viewHolder.itemView.isSelected());
            this.addSelectedItem(itemId, viewHolder, fileMessage);
        }
    }

    private void setOnLongClickListener(int itemId, BaseViewHolder viewHolder, FileMessage fileMessage) {
        viewHolder.setOnLongClickListener(v -> this.onViewLongClick(itemId, viewHolder, fileMessage));
    }

    @Override
    public View.OnLongClickListener getOnLongClickListener(int itemId, BaseViewHolder viewHolder, FileMessage fileMessage) {
        return v -> this.onViewLongClick(itemId, viewHolder, fileMessage);
    }

    private boolean onViewLongClick(int itemId, BaseViewHolder viewHolder, FileMessage fileMessage) {
        if (!this.isSelectable()) {
            if (fileMessage != null && !this.hasFilePath(fileMessage)) {
                return false;
            }
            this.setSelectable(true);
            viewHolder.itemView.setSelected(true);
            this.addSelectedItem(itemId, viewHolder, fileMessage);
            return true;
        }
        return false;
    }

    @Override
    public void onViewRecycled(RecyclerView.ViewHolder viewHolder) {
        viewHolder.itemView.setLongClickable(false);
    }

    private void setSelected(int itemId, BaseViewHolder viewHolder, FileMessage fileMessage) {
        if (this.mBundledViewData != null && this.mBundledViewData.size() != 0) {
            if (this.mBundledViewData.contains(itemId)) {
                viewHolder.itemView.setSelected(true);
                this.addSelectedItem(itemId, viewHolder, fileMessage);
                return;
            }
            this.enableActionItemsAsRequired();
        }
        viewHolder.itemView.setSelected(this.isSelected(itemId));
    }

    @Override
    public void applyContextualActionBehavior(int itemId, BaseViewHolder viewHolder, FileMessage fileMessage) {
        this.setOnLongClickListener(itemId, viewHolder, fileMessage);
        this.setOnClickListener(itemId, viewHolder, fileMessage);
        this.setSelected(itemId, viewHolder, fileMessage);
    }

    public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
        if (this.isSelectable()) {
            this.mMode = mode;
            this.mMenuCallback.onMenuOpen();
            this.mActivityProvider.getActivity().getMenuInflater().inflate(R.menu.lpmessaging_ui_action_mode_item_menu, menu2);
            this.copyItem = menu2.findItem(R.id.action_mode_menu_copy);
            this.moreItem = menu2.findItem(R.id.action_mode_menu_more);
            this.moreItem.getSubMenu().findItem(R.id.action_mode_more_menu_share).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this);
            this.moreItem.getSubMenu().findItem(R.id.action_mode_more_menu_save).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this);
            return true;
        }
        return false;
    }

    private void enableActionItemsAsRequired() {
        if (this.mMode != null) {
            if (this.mBundledViewData.size() == 0) {
                this.setSelectable(false);
            } else if (this.mBundledViewData.size() == 1 && this.hasFile()) {
                this.copyItem.setVisible(false);
                this.moreItem.setVisible(true);
            } else if (this.mBundledViewData.size() > 1 && this.hasFile()) {
                this.copyItem.setVisible(false);
                this.moreItem.setVisible(false);
            } else {
                this.copyItem.setVisible(true);
                this.moreItem.setVisible(false);
            }
        }
    }

    public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
        return false;
    }

    public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
        if (item.getItemId() == R.id.action_mode_menu_copy) {
            String textToCopy = this.getSelectionTextToCopy();
            this.mContextualItemAction.PerformCopyTextToClipboard(textToCopy);
            mode.finish();
            return true;
        }
        return item.getItemId() == R.id.action_mode_menu_more;
    }

    private String getSelectionTextToCopy() {
        StringBuilder textToCopy = new StringBuilder();
        for (int i = 0; i < this.mSelectedItemIds.size(); ++i) {
            LPLog.INSTANCE.d(TAG, "mSelectedPositions.keyAt(i) = " + this.mSelectedItemIds.keyAt(i));
            textToCopy.append(this.mSelectedItemIds.get(this.mSelectedItemIds.keyAt(i)));
            if (i >= this.mSelectedItemIds.size() - 1) continue;
            textToCopy.append('\n');
        }
        return textToCopy.toString();
    }

    public void onDestroyActionMode(ActionMode mode) {
        this.clearAll();
        this.mMenuCallback.onMenuClose();
        this.mMode = null;
    }

    public boolean onMenuItemClick(MenuItem item) {
        File file = (File)this.mSelectedItemIds.get(this.mSelectedItemIds.keyAt(0));
        if (file != null) {
            if (item.getItemId() == R.id.action_mode_more_menu_share) {
                this.mContextualItemAction.performFileAction(file.getPath(), ContextualItemAction.Action.SHARE);
                return true;
            }
            if (item.getItemId() == R.id.action_mode_more_menu_save) {
                this.mContextualItemAction.performSaveFile(file.getPath());
                return true;
            }
        }
        return false;
    }
}

