/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils.markdownlink;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0006\u0010\u0019\u001a\u00020\u001aR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\bR\"\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/liveperson/infra/messaging_ui/utils/markdownlink/MarkdownHyperlinkItem;", "", "()V", "end", "", "getEnd", "()I", "setEnd", "(I)V", "<set-?>", "", "link", "getLink", "()Ljava/lang/String;", "start", "getStart", "setStart", "title", "getTitle", "buildHyperlinkItem", "", "message", "findMiddleBracketsIndexes", "", "string", "isValid", "", "Companion", "messaging_ui_release"})
public final class MarkdownHyperlinkItem {
    private int start = -1;
    private int end = -1;
    @Nullable
    private String title;
    @Nullable
    private String link;
    private static final String EMPTY_STRING = "";
    private static final int BRACKET_CHARACTER_LENGTH = 1;
    private static final String MIDDLE_BRACKETS = "](";
    private static final String HTTP_STRING = "http://";
    private static final String HTTPS_STRING = "https://";
    public static final Companion Companion = new Companion(null);

    public final int getStart() {
        return this.start;
    }

    public final void setStart(int n) {
        this.start = n;
    }

    public final int getEnd() {
        return this.end;
    }

    public final void setEnd(int n) {
        this.end = n;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    @Nullable
    public final String getLink() {
        return this.link;
    }

    public final void buildHyperlinkItem(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        String string2 = message;
        int n = this.start;
        int n2 = this.end;
        boolean bl = false;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        int titleStartIndex = 5;
        List<Integer> middleBracketsIndexList = this.findMiddleBracketsIndexes(string4);
        int lastUrlCharacterIndex = string4.length() - "#/md#".length() - 1;
        Iterator<Integer> iterator = middleBracketsIndexList.iterator();
        while (iterator.hasNext()) {
            String string5;
            int middleBracketsIndex = ((Number)iterator.next()).intValue();
            String string6 = string4;
            MarkdownHyperlinkItem markdownHyperlinkItem = this;
            int n3 = 0;
            String string7 = string6;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(titleStartIndex, middleBracketsIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            markdownHyperlinkItem.title = string5 = string8;
            string6 = string4;
            n3 = middleBracketsIndex + MIDDLE_BRACKETS.length();
            markdownHyperlinkItem = this;
            boolean bl2 = false;
            String string9 = string6;
            if (string9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.substring(n3, lastUrlCharacterIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            markdownHyperlinkItem.link = string5 = string10;
            if (this.link == null) {
                this.link = EMPTY_STRING;
                break;
            }
            String string11 = this.link;
            if (string11 == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.startsWith((String)string11, (String)HTTP_STRING, (boolean)true)) break;
            String string12 = this.link;
            if (string12 == null) {
                Intrinsics.throwNpe();
            }
            if (!StringsKt.startsWith((String)string12, (String)HTTPS_STRING, (boolean)true)) continue;
            break;
        }
    }

    public final boolean isValid() {
        return this.start != -1 && this.end > this.start && !TextUtils.isEmpty((CharSequence)this.title) && !TextUtils.isEmpty((CharSequence)this.link);
    }

    private final List<Integer> findMiddleBracketsIndexes(String string2) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int index = 5;
        while (index <= string2.length() - "#/md#".length() - MIDDLE_BRACKETS.length()) {
            String string3;
            String string4 = string2;
            int n = index + MIDDLE_BRACKETS.length();
            String string5 = MIDDLE_BRACKETS;
            boolean bl = false;
            String string6 = string4;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string6.substring(index, n), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (Intrinsics.areEqual((Object)string5, (Object)string3)) {
                indexList.add(index);
                index += MIDDLE_BRACKETS.length();
                continue;
            }
            ++index;
        }
        return indexList;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/liveperson/infra/messaging_ui/utils/markdownlink/MarkdownHyperlinkItem$Companion;", "", "()V", "BRACKET_CHARACTER_LENGTH", "", "EMPTY_STRING", "", "HTTPS_STRING", "HTTP_STRING", "MIDDLE_BRACKETS", "messaging_ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

