/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.snackbar.Snackbar;
import com.liveperson.infra.ui.view.sticky.StickyHeadersLinearLayoutManager;

public class StickyHeadersBehavior
extends CoordinatorLayout.Behavior<View> {
    public StickyHeadersBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean layoutDependsOn(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View dependency) {
        return dependency instanceof Snackbar.SnackbarLayout;
    }

    public boolean onDependentViewChanged(@NonNull CoordinatorLayout parent, View child, View dependency) {
        float translationY = Math.min(0.0f, dependency.getTranslationY() - (float)dependency.getHeight());
        this.setTranslationY(child, translationY);
        return true;
    }

    public void onDependentViewRemoved(CoordinatorLayout parent, View child, @NonNull View dependency) {
        super.onDependentViewRemoved(parent, child, dependency);
        float translationY = Math.min(0, parent.getBottom() - child.getBottom());
        this.setTranslationY(child, translationY);
    }

    private void setTranslationY(View child, float translationY) {
        RecyclerView recyclerView = (RecyclerView)child;
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        recyclerView.setTranslationY(translationY);
        if (manager instanceof StickyHeadersLinearLayoutManager) {
            StickyHeadersLinearLayoutManager stickyManager = (StickyHeadersLinearLayoutManager)manager;
            stickyManager.setStickyHeaderTranslationY(-translationY);
        }
    }
}

