/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.content.Context;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.ui.view.uicomponents.ICloseMenuListener;
import com.liveperson.infra.ui.view.uicomponents.IOverflowMenu;

public class AttachmentMenu
extends LinearLayout
implements IOverflowMenu {
    private Context mContext;
    private View mMenuView;
    private ImageView mGalleryButton;
    private ImageView mCameraButton;
    private ImageView mDocumentButton;
    private TextView mGalleryText;
    private TextView mCameraText;
    private TextView mDocumentText;
    private AttachmentMenuListener mListener;
    private ICloseMenuListener menuListener;
    private boolean mIsMenuOpen = false;

    public AttachmentMenu(Context context) {
        super(context);
        this.init(context);
    }

    public AttachmentMenu(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AttachmentMenu(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        LayoutInflater.from((Context)context).inflate(R.layout.lpmessaging_ui_atachment_menu_layout, (ViewGroup)this);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mMenuView = this.findViewById(R.id.menu_view);
        this.mGalleryButton = (ImageView)this.findViewById(R.id.gallery_button);
        this.mCameraButton = (ImageView)this.findViewById(R.id.camera_button);
        this.mDocumentButton = (ImageView)this.findViewById(R.id.document_button);
        this.mGalleryText = (TextView)this.findViewById(R.id.gallery_text);
        this.mCameraText = (TextView)this.findViewById(R.id.camera_text);
        this.mDocumentText = (TextView)this.findViewById(R.id.document_text);
        this.mCameraButton.getDrawable().setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_attachment_menu_item_icon_color), PorterDuff.Mode.SRC_IN);
        this.mGalleryButton.getDrawable().setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_attachment_menu_item_icon_color), PorterDuff.Mode.SRC_IN);
        this.mDocumentButton.getDrawable().setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_attachment_menu_item_icon_color), PorterDuff.Mode.SRC_IN);
        this.mGalleryButton.setOnClickListener(v -> {
            if (this.mListener != null) {
                this.mListener.onGalleryButtonPressed();
            }
        });
        this.mCameraButton.setOnClickListener(v -> {
            if (this.mListener != null) {
                this.mListener.onCameraButtonPressed();
            }
        });
        this.mDocumentButton.setOnClickListener(v -> this.mListener.onDocumentButtonPressed());
        this.mMenuView.setOnFocusChangeListener((v, hasFocus) -> {
            if (!hasFocus && this.isMenuOpen()) {
                this.hide();
            }
        });
    }

    public void setListener(AttachmentMenuListener listener) {
        this.mListener = listener;
    }

    public void show() {
        this.mIsMenuOpen = true;
        this.resetControlsSize();
        this.mMenuView.setVisibility(0);
        Animator translateMenuAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_reveal_attachment_menu);
        translateMenuAnimator.setTarget((Object)this.mMenuView);
        Animator revealGalleryAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_reveal_item_menu_item);
        Animator revealCameraAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_reveal_item_menu_item);
        Animator revealDocumentAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_reveal_item_menu_item);
        Animator revealGalleryTextAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_reveal_item_menu_text);
        Animator revealCameraTextAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_reveal_item_menu_text);
        Animator revealDocumentTextAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_reveal_item_menu_text);
        revealGalleryAnimator.setTarget((Object)this.mGalleryButton);
        revealCameraAnimator.setTarget((Object)this.mCameraButton);
        revealDocumentAnimator.setTarget((Object)this.mDocumentButton);
        revealGalleryTextAnimator.setTarget((Object)this.mGalleryText);
        revealCameraTextAnimator.setTarget((Object)this.mCameraText);
        revealDocumentTextAnimator.setTarget((Object)this.mDocumentText);
        AnimatorSet animatorSet = new AnimatorSet();
        revealCameraAnimator.setStartDelay(75L);
        revealCameraTextAnimator.setStartDelay(75L);
        animatorSet.play(translateMenuAnimator).before(revealGalleryAnimator);
        animatorSet.playTogether(new Animator[]{revealGalleryAnimator, revealCameraAnimator, revealDocumentAnimator, revealGalleryTextAnimator, revealCameraTextAnimator, revealDocumentTextAnimator});
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                AttachmentMenu.this.mGalleryText.invalidate();
                AttachmentMenu.this.mCameraText.invalidate();
                AttachmentMenu.this.mDocumentText.invalidate();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animatorSet.start();
        this.mMenuView.requestFocus();
        this.mMenuView.setOnKeyListener((v, keyCode, event) -> {
            if (keyCode == 4) {
                this.hide();
                return true;
            }
            return false;
        });
    }

    public void hide() {
        this.mMenuView.setOnKeyListener(null);
        Animator translateMenuAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_hide_attachment_menu);
        translateMenuAnimator.setTarget((Object)this.mMenuView);
        Animator hideGalleryAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_hide_item_menu_item);
        Animator hideCameraAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_hide_item_menu_item);
        Animator hideDocumentAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_hide_item_menu_item);
        Animator hideGalleryTextAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_hide_item_menu_text);
        Animator hideCameraTextAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_hide_item_menu_text);
        Animator hideDocumentTextAnimator = AnimatorInflater.loadAnimator((Context)this.mContext, (int)R.animator.lpmessaging_ui_hide_item_menu_text);
        hideGalleryAnimator.setTarget((Object)this.mGalleryButton);
        hideCameraAnimator.setTarget((Object)this.mCameraButton);
        hideDocumentAnimator.setTarget((Object)this.mDocumentButton);
        hideGalleryTextAnimator.setTarget((Object)this.mGalleryText);
        hideCameraTextAnimator.setTarget((Object)this.mCameraText);
        hideDocumentTextAnimator.setTarget((Object)this.mDocumentText);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{hideGalleryAnimator, hideCameraAnimator, hideDocumentAnimator, hideGalleryTextAnimator, hideCameraTextAnimator, hideDocumentTextAnimator});
        animatorSet.play(translateMenuAnimator).after(hideGalleryAnimator);
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                AttachmentMenu.this.mMenuView.setVisibility(8);
                AttachmentMenu.this.resetControlsSize();
                AttachmentMenu.this.mIsMenuOpen = false;
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animatorSet.start();
        this.menuListener.onCloseMenu();
    }

    public void setOnCloseListener(ICloseMenuListener menuListener) {
        this.menuListener = menuListener;
    }

    public boolean isMenuOpen() {
        return this.mIsMenuOpen;
    }

    private void resetControlsSize() {
        this.mGalleryButton.setScaleX(0.0f);
        this.mGalleryButton.setScaleY(0.0f);
        this.mCameraButton.setScaleX(0.0f);
        this.mCameraButton.setScaleY(0.0f);
        this.mDocumentButton.setScaleX(0.0f);
        this.mDocumentButton.setScaleY(0.0f);
        this.mGalleryText.setScaleX(0.0f);
        this.mGalleryText.setScaleY(0.0f);
        this.mCameraText.setScaleX(0.0f);
        this.mCameraText.setScaleY(0.0f);
        this.mDocumentText.setScaleX(0.0f);
        this.mDocumentText.setScaleY(0.0f);
    }

    public static interface AttachmentMenuListener {
        public void onGalleryButtonPressed();

        public void onCameraButtonPressed();

        public void onDocumentButtonPressed();
    }
}

