/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.toolbar;

import android.content.Context;
import android.graphics.PorterDuff;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.messaging_ui.MessagingUIFactory;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.IFeedbackActions;
import com.liveperson.infra.messaging_ui.toolbar.LPToolBar;
import com.liveperson.infra.ui.view.utils.picasso.CircleTransform;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.AmsAccount;
import com.liveperson.messaging.model.Dialog;
import com.squareup.picasso.Transformation;

public class ConversationToolBar
extends LPToolBar {
    protected LocalBroadcastReceiver mAgentTypingReceiver;
    private TextView mToolbarTitle;
    private Button mToolbarFeedBackAction;
    private TextView mToolbarIsTyping;
    private LocalBroadcastReceiver mAgentUpdatesReceiver;
    private ImageView mToolbarAgentAvatar;
    private LinearLayout mAgentDetailsContainer;
    private boolean mIsTypingAnnouncementEnabled;
    private String mIsTypingString;
    private String mAgentIsTypingString;

    public ConversationToolBar(Context context) {
        super(context);
    }

    public ConversationToolBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ConversationToolBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mToolbarFeedBackAction = (Button)this.findViewById(R.id.lpui_toolbar_feedback_action);
    }

    @Override
    public void onResume() {
        this.registerReceivers();
    }

    @Override
    public void onPause() {
        this.unregisterReceivers();
    }

    @Override
    public void onInitCompleted() {
        RelativeLayout titleContainer = (RelativeLayout)this.findViewById(R.id.lpmessaging_ui_toolbar_avatar_title_container);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.lpmessaging_ui_toolbar_avatar_title, (ViewGroup)titleContainer, true);
        this.mAgentDetailsContainer = (LinearLayout)this.findViewById(R.id.lpui_avatar_layout);
        this.mToolbarTitle = (TextView)this.findViewById(R.id.lpui_toolbar_title);
        this.setTitleAsAccessibilityHeading((View)this.mToolbarTitle);
        this.mToolbarIsTyping = (TextView)this.findViewById(R.id.lpui_toolbar_typing);
        this.mToolbarAgentAvatar = (ImageView)this.findViewById(R.id.lpui_toolbar_agent_avatar);
        boolean isTypingAnnouncementEnabled = Configuration.getBoolean((int)R.bool.announce_agent_typing);
        boolean isTypingAnnouncementEnabledInMessageBubble = Configuration.getBoolean((int)R.bool.show_agent_typing_in_message_bubble);
        this.mIsTypingAnnouncementEnabled = isTypingAnnouncementEnabled && !isTypingAnnouncementEnabledInMessageBubble;
        this.mIsTypingString = this.getResources().getString(R.string.lp_accessibility_is_typing);
        this.mAgentIsTypingString = this.getResources().getString(R.string.lp_accessibility_agent_is_typing);
        this.onResume();
    }

    @Override
    protected void initReceivers() {
        this.initAgentTypingReceiver();
        this.initAgentChangedReceiver();
    }

    private void initAgentTypingReceiver() {
        if (this.mAgentTypingReceiver == null) {
            this.mAgentTypingReceiver = new LocalBroadcastReceiver.Builder().addAction("agent_typing").build((context, intent) -> {
                boolean isTyping = intent.getBooleanExtra("is_typing", false);
                this.setIsTyping(isTyping);
            });
        }
    }

    private void initAgentChangedReceiver() {
        if (this.mAgentUpdatesReceiver == null) {
            this.mAgentUpdatesReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_AGENT_CHANGED").addAction("BROADCAST_KEY_AUTH_COMPLETED_ACTION").build((context, intent) -> this.updateAgent());
        }
    }

    @Override
    protected void registerReceivers() {
        this.initReceivers();
        this.mAgentUpdatesReceiver.register();
        this.mAgentTypingReceiver.register();
    }

    @Override
    protected void unregisterReceivers() {
        this.mAgentUpdatesReceiver.unregister();
        this.mAgentTypingReceiver.unregister();
        this.setIsTyping(false);
    }

    private void setIsTyping(boolean isTyping) {
        if (this.mToolbarIsTyping != null) {
            if (isTyping && this.conversationsHistoryStateToDisplay != LPConversationsHistoryStateToDisplay.CLOSE && !this.isConversationInBackground) {
                if (this.mIsTypingAnnouncementEnabled) {
                    this.mToolbarIsTyping.setVisibility(0);
                    String stringToAnnounce = !TextUtils.isEmpty((CharSequence)this.mToolbarTitle.getText().toString()) ? String.format(this.mIsTypingString, this.mToolbarTitle.getText().toString()) : this.mAgentIsTypingString;
                    this.announceAccessibilityMessage((View)this.mToolbarIsTyping, stringToAnnounce);
                }
            } else {
                this.mToolbarIsTyping.setVisibility(4);
            }
        }
    }

    private void announceAccessibilityMessage(View view, String stringToAnnounce) {
        view.announceForAccessibility((CharSequence)stringToAnnounce);
    }

    @Override
    public void setAgentName(String agentName) {
        this.mToolbarTitle.setText((CharSequence)agentName);
    }

    private void setAgentAvatarURI(String agentAvatarUrl) {
        if (TextUtils.isEmpty((CharSequence)agentAvatarUrl)) {
            this.mToolbarAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_brand_logo);
            this.mToolbarAgentAvatar.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.agent_avatar_icon_color), PorterDuff.Mode.MULTIPLY);
            return;
        }
        this.mToolbarAgentAvatar.setColorFilter(null);
        this.mToolbarAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_brand_logo);
        PicassoUtils.get((Context)this.getContext()).load(agentAvatarUrl).noPlaceholder().transform((Transformation)new CircleTransform()).into(this.mToolbarAgentAvatar);
    }

    @Override
    protected void updateAgent() {
        boolean hasFinishedAuthenticating;
        Messaging controller = MessagingFactory.getInstance().getController();
        Dialog dialog = controller.amsDialogs.getActiveDialog();
        AmsAccount account = controller.mAccountsController.getAccount(this.mBrandId);
        boolean bl = hasFinishedAuthenticating = account != null && account.hasFinishedAuthenticating();
        if (dialog == null || !hasFinishedAuthenticating) {
            this.putBrandLogo();
            this.removeAgentIconListener();
        } else {
            String currentAgentId = dialog.getAssignedAgentId();
            this.setAgentIconListener(currentAgentId);
            controller.amsUsers.getUserById(currentAgentId).setPostQueryOnUI(data -> {
                if (data == null) {
                    this.putBrandLogo();
                    this.removeAgentIconListener();
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)data.getNickname())) {
                    this.mAgentDetailsContainer.setVisibility(4);
                    this.setAgentName(data.getNickname());
                    this.setAgentAvatarURI(data.getAvatarUrl());
                    this.mAgentDetailsContainer.setVisibility(0);
                }
            }).execute();
        }
    }

    private void setAgentIconListener(String currentConversationAgentID) {
        this.mToolbarAgentAvatar.setOnClickListener(v -> MessagingUIFactory.getInstance().onAgentAvatarTapped(currentConversationAgentID));
    }

    private void removeAgentIconListener() {
        this.mToolbarAgentAvatar.setOnClickListener(null);
    }

    private void putBrandLogo() {
        this.mAgentDetailsContainer.setVisibility(4);
        this.mToolbarAgentAvatar.setColorFilter(null);
        this.mToolbarAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_brand_logo);
        this.setAgentName(this.getContext().getString(R.string.brand_name));
        this.mAgentDetailsContainer.setVisibility(0);
    }

    @Override
    public void setFeedBackMode(boolean feedBackMode, IFeedbackActions actions) {
        this.mToolbarIsTyping.setVisibility(4);
        if (feedBackMode) {
            this.setBackgroundColor(this.getResources().getColor(R.color.feedback_toolbar_background));
            this.mToolbarAgentAvatar.setVisibility(0);
            this.mToolbarTitle.setVisibility(0);
            this.mToolbarFeedBackAction.setVisibility(0);
            this.mToolbarFeedBackAction.setText(R.string.lp_skip);
            this.mToolbarFeedBackAction.setTextColor(this.getResources().getColor(R.color.feedback_toolbar_textColor));
            this.mToolbarFeedBackAction.setOnClickListener(v -> actions.skipFeedBackScreen());
            this.isConversationInBackground = true;
        } else {
            this.mToolbarFeedBackAction.setVisibility(8);
            this.isConversationInBackground = false;
        }
    }

    @Override
    public void setFullImageMode(boolean fullImageMode) {
        this.mToolbarIsTyping.setVisibility(4);
        if (fullImageMode) {
            this.mToolbarAgentAvatar.setVisibility(8);
            this.mToolbarTitle.setVisibility(8);
            this.isConversationInBackground = true;
            this.setBackgroundColor(this.getResources().getColor(R.color.lp_transparent));
        } else {
            this.mToolbarAgentAvatar.setVisibility(0);
            this.mToolbarTitle.setVisibility(0);
            this.isConversationInBackground = false;
            this.setBackgroundColor(this.getResources().getColor(R.color.conversation_toolbar_color));
        }
    }

    @Override
    public void onSurveySubmitted(IFeedbackActions actions) {
        this.mToolbarFeedBackAction.setText(R.string.lp_done);
        this.mToolbarFeedBackAction.setTextColor(this.getResources().getColor(R.color.feedback_toolbar_textColor));
        this.mToolbarFeedBackAction.setOnClickListener(v -> actions.closeFeedBackScreen());
    }

    @Override
    public void updateToolBarData() {
        this.updateAgent();
    }

    @Override
    public void setBrandId(String brandId) {
        this.mBrandId = brandId;
    }
}

