/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.notification;

import android.content.Context;
import android.content.Intent;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.handler.NotificationHandler;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.model.PushMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum NotificationController implements Clearable
{
    instance;

    private static final String TAG;
    public static final String ACTION_LP_UPDATE_NUM_UNREAD_MESSAGES_ACTION = "ACTION_LP_UPDATE_NUM_UNREAD_MESSAGES_ACTION";
    public static final String ACTION_LP_UPDATE_NUM_UNREAD_MESSAGES_EXTRA = "ACTION_LP_UPDATE_NUM_UNREAD_MESSAGES_EXTRA";
    private Map<String, List<PushMessage>> mPushMessages;
    private Map<String, Integer> mUnreadMessagesCounter = new HashMap<String, Integer>();

    private NotificationController() {
        this.mPushMessages = new HashMap<String, List<PushMessage>>();
    }

    public void addMessageAndDisplayNotification(Context context, String brandId, PushMessage message, boolean showNotification, int notification_icon) {
        LPLog.INSTANCE.d(TAG, "addMessageAndDisplayNotification " + LPLog.INSTANCE.mask((Object)message));
        int newValueCounter = this.addMessageToCounter(brandId, message);
        this.sendUpdateIntent(context, newValueCounter);
        LPLog.INSTANCE.d(TAG, "addMessage after formatting: " + LPLog.INSTANCE.mask((Object)message));
        this.showNotification(context, brandId, showNotification, newValueCounter, notification_icon);
    }

    public int addMessageToCounter(String brandId, PushMessage message) {
        this.addMessageToList(brandId, message);
        return this.addToUnreadCounters(brandId, message);
    }

    private void addMessageToList(String brandId, PushMessage message) {
        List<PushMessage> messagesForBrand = this.mPushMessages.get(brandId);
        if (messagesForBrand == null) {
            messagesForBrand = new ArrayList<PushMessage>();
            this.mPushMessages.put(brandId, messagesForBrand);
        }
        messagesForBrand.add(message);
    }

    private void sendUpdateIntent(Context context, int newValueCounter) {
        Intent update = new Intent(ACTION_LP_UPDATE_NUM_UNREAD_MESSAGES_ACTION);
        update.putExtra(ACTION_LP_UPDATE_NUM_UNREAD_MESSAGES_EXTRA, newValueCounter);
        context.sendBroadcast(update);
    }

    private int addToUnreadCounters(String brandId, PushMessage message) {
        int newValue;
        if (message.getCurrentUnreadMessagesCounter() == -1) {
            LPLog.INSTANCE.d(TAG, "No unread messages badge counter in push messages. using fallback.");
            int unreadMessages = 0;
            if (this.mUnreadMessagesCounter.containsKey(brandId)) {
                unreadMessages = this.mUnreadMessagesCounter.get(brandId);
            }
            newValue = unreadMessages + 1;
        } else {
            LPLog.INSTANCE.d(TAG, "Got unread messages badge counter in push messages. Using it!");
            newValue = message.getCurrentUnreadMessagesCounter();
        }
        this.mUnreadMessagesCounter.put(brandId, newValue);
        LPLog.INSTANCE.d(TAG, "Unread messages badge counter: " + newValue);
        return newValue;
    }

    private void showNotification(Context context, String brandId, boolean showNotification, int unreadMessagesCounter, int notification_icon) {
        List<PushMessage> messagesForBrand = this.mPushMessages.get(brandId);
        if (showNotification && messagesForBrand != null && !messagesForBrand.isEmpty()) {
            PushMessage lastMessage = messagesForBrand.get(messagesForBrand.size() - 1);
            String notificationTitle = lastMessage.getFrom();
            String notificationMessage = unreadMessagesCounter > 1 ? unreadMessagesCounter + " " + context.getString(R.string.lp_new_messages) : lastMessage.getMessage();
            new NotificationHandler(context, notificationTitle, notificationMessage).setIconResourceId(notification_icon).showNotification();
        }
    }

    public int getNumUnreadMessages(String brandId) {
        if (this.mUnreadMessagesCounter.containsKey(brandId)) {
            return this.mUnreadMessagesCounter.get(brandId);
        }
        return 0;
    }

    public void clearMessagesForBrand(Context context, String brandId) {
        LPLog.INSTANCE.i(TAG, "Clearing notification messages for brand " + brandId);
        this.mPushMessages.remove(brandId);
        this.mUnreadMessagesCounter.remove(brandId);
        this.sendUpdateIntent(context, 0);
        NotificationHandler.Android.hideNotification((Context)context, (String)brandId);
    }

    public void clear() {
        LPLog.INSTANCE.d(TAG, "Clearing all data");
        this.mPushMessages.clear();
        this.mUnreadMessagesCounter.clear();
    }

    static {
        TAG = NotificationController.class.getSimpleName();
    }
}

