package com.liveperson.monitoring.sdk.api;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.liveperson.infra.log.LPLog;
import com.liveperson.lp_monitoring_sdk.BuildConfig;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.model.LPMonitoringIdentity;
import com.liveperson.monitoring.sdk.MonitoringParams;
import com.liveperson.monitoring.sdk.callbacks.EngagementCallback;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.monitoring.sdk.callbacks.SdeCallback;

import java.util.List;


/**
 * Liveperson Monitoring SDK entry point.
 *
 * You must initialize this class before use.
 */
public class LivepersonMonitoring {

	public static final String TAG = "LivepersonMonitoring";

	private LivepersonMonitoring() {
	}


	/**
	 * Send and SDE
	 * @param context
	 * @param identities
	 * @param monitoringParams
	 * @param callback
	 */
	public static void sendSde(Context context, @NonNull List<LPMonitoringIdentity> identities, @NonNull MonitoringParams monitoringParams, SdeCallback callback) {
		if (!MonitoringFactory.INSTANCE.isInitialized()) {
			LPLog.INSTANCE.w(TAG, "sendSde: not initialized");
			if (callback != null) {
				callback.onError(MonitoringErrorType.NOT_INITIALIZED, null);
			}
			return;
		}

		if (context == null) {
			LPLog.INSTANCE.w(TAG, "Context is null. Aborting.");
			if (callback != null) {
				callback.onError(MonitoringErrorType.PARAMETER_MISSING, new Exception("Context parameter is missing"));
			}
			return;
		}

		if (identities.isEmpty()) {
			LPLog.INSTANCE.w(TAG, "Identity & ConsumerId is mandatory.");
			if (callback != null) {
				callback.onError(MonitoringErrorType.PARAMETER_MISSING, new Exception("Identity & ConsumerId is mandatory"));
			}
			return;
		}

		if (monitoringParams.getEngagementAttributes() == null) {
			LPLog.INSTANCE.w(TAG, "sendSde: EngagementAttributes were not provided. Aborting.");
			callback.onError(MonitoringErrorType.PARAMETER_MISSING, new Exception("EngagementAttributes were not provided"));
			return;
		}

		MonitoringFactory.INSTANCE.sendSde(context, identities, monitoringParams, callback);
	}

	/**
	 * Get engagement
	 * @param context
	 * @param identities
	 * @param monitoringParams
	 * @param callback
	 */
	public static void getEngagement(Context context, @Nullable List<LPMonitoringIdentity> identities, MonitoringParams monitoringParams, EngagementCallback callback){
		if (!MonitoringFactory.INSTANCE.isInitialized()) {
			LPLog.INSTANCE.w(TAG, "getEngagement: not initialized");
			if (callback != null) {
				callback.onError(MonitoringErrorType.NOT_INITIALIZED, null);
			}
			return;
		}

		if (context == null) {
			LPLog.INSTANCE.w(TAG, "Context is null. Aborting.");
			if (callback != null) {
				callback.onError(MonitoringErrorType.PARAMETER_MISSING, new Exception("Context parameter is missing"));
			}
			return;
		}


		MonitoringFactory.INSTANCE.getEngagement(context, identities, monitoringParams, callback);

	}

	/**
	 * Get the LivePerson Monitoring SDK version
	 *
	 * @return
	 */
	public static String getSDKVersion() {
		return BuildConfig.VERSION_NAME;
	}

}
